//
//  YHMyUserInfoView.swift
//  galaxy
//
//  Created by Dufet on 2025/2/13.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyUserInfoView: UIView {

    static let likeTag = 9527
    static let collectTag = 9528
    static let scanTag = 9529
    
    var vipLevel: YHUserVipLevel = .none {
        didSet {
            var vipImg = ""
            var vipImgWidth = 0.0
            
            if vipLevel == .gold {
                vipImg = "mine_vip_1"
                vipImgWidth = 38.0

            } else if vipLevel == .platinum {
                vipImg = "mine_vip_2"
                vipImgWidth = 44.0
            
            } else if vipLevel == .diamond {
                vipImg = "mine_vip_3"
                vipImgWidth = 49.0
            }
            
            vipImgView.image = UIImage(named: vipImg)
            vipImgView.snp.updateConstraints { make in
                make.width.equalTo(vipImgWidth)
            }
        }
    }
    
    var avatarClickBlock: (() -> Void)?
    var nickNameClickBlock: (() -> Void)?
    var likeClick: (() -> Void)?
    var collectClick: (() -> Void)?
    var recentScanClick: (() -> Void)?
    var enterClick: (() -> Void)?
    
    lazy var contentView: UIView = {
        let view = UIView()
        let tap = UITapGestureRecognizer(target: self, action: #selector(enterBtnClicked))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var avarImgView: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "mine_head_logout"))
        imgView.isUserInteractionEnabled = true
        imgView.layer.cornerRadius = 27.0
        imgView.contentMode = .scaleAspectFill
        imgView.clipsToBounds = true
//        let tap = UITapGestureRecognizer(target: self, action: #selector(didAvarImgViewTapped))
//        imgView.addGestureRecognizer(tap)
        return imgView
    }()
    
    lazy var userNameLabel: UILabel = {
        let label = UILabel()
        label.text = "登录/注册".local
        label.textColor = .mainTextColor
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_M(ofSize: 21)
        label.isUserInteractionEnabled = true
//        let tap = UITapGestureRecognizer(target: self, action: #selector(didNickNameTapped))
//        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var likeLabel: UILabel = {
        let label = UILabel()
        label.text = "点赞 0".local
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.isUserInteractionEnabled = true
        label.tag = Self.likeTag
        let tap = UITapGestureRecognizer(target: self, action: #selector(tap(gestureRecognizer:)))
        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var collectLabel: UILabel = {
        let label = UILabel()
        label.text = "收藏 0".local
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.isUserInteractionEnabled = true
        label.tag = Self.collectTag
        let tap = UITapGestureRecognizer(target: self, action: #selector(tap(gestureRecognizer:)))
        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var scanLabel: UILabel = {
        let label = UILabel()
        label.text = "最近浏览 0".local
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = NSTextAlignment.left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.isUserInteractionEnabled = true
        label.tag = Self.scanTag
        let tap = UITapGestureRecognizer(target: self, action: #selector(tap(gestureRecognizer:)))
        label.addGestureRecognizer(tap)
        return label
    }()
    
    private lazy var line1View: UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0x92959D, alpha: 0.2)
        return line
    }()
    
    private lazy var line2View: UIView = {
        let line = UIView()
        line.backgroundColor = UIColor(hex: 0x92959D, alpha: 0.2)
        return line
    }()
    
    lazy var vipImgView: UIImageView = {
        let imgV = UIImageView()
        return imgV
    }()
    
    lazy var arrowImgView: UIImageView = {
        let imgV = UIImageView()
        imgV.image = UIImage(named: "form_right_arrow")
        imgV.isHidden = true
        return imgV
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        self.clipsToBounds = true
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    static func createView() -> YHMyUserInfoView {
       let view = YHMyUserInfoView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 107))
       return view
    }
    
    private func createUI() {
        
        self.addSubview(contentView)
        contentView.addSubview(avarImgView)
        contentView.addSubview(userNameLabel)
        contentView.addSubview(vipImgView)

        contentView.addSubview(likeLabel)
        contentView.addSubview(collectLabel)
        contentView.addSubview(scanLabel)
        contentView.addSubview(line1View)
        contentView.addSubview(line2View)
        
        contentView.addSubview(arrowImgView)
        
        contentView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(54)
            make.top.equalTo(21)
            make.bottom.equalTo(-31)
        }

        avarImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 55, height: 55))
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(0)
        }
        
        userNameLabel.snp.makeConstraints { make in
            make.left.equalTo(avarImgView.snp.right).offset(16)
            make.top.equalTo(avarImgView)
            make.height.equalTo(29.0)
        }
        
        vipImgView.snp.makeConstraints { make in
            make.width.equalTo(43)
            make.height.equalTo(16)
            make.centerY.equalTo(userNameLabel)
            make.left.equalTo(userNameLabel.snp.right).offset(8)
            make.right.lessThanOrEqualTo(arrowImgView.snp.left).offset(0)
        }
        
        likeLabel.snp.makeConstraints { make in
            make.left.equalTo(userNameLabel)
            make.right.equalTo(line1View.snp.left).offset(-12)
            make.height.equalTo(17.0)
            make.top.equalTo(userNameLabel.snp.bottom).offset(6)
        }
        likeLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        likeLabel.setContentHuggingPriority(.required, for: .horizontal)
        
        line1View.snp.makeConstraints { make in
            make.centerY.equalTo(likeLabel)
            make.size.equalTo(CGSize(width: 1, height: 12))
        }
        
        collectLabel.snp.makeConstraints { make in
            make.left.equalTo(line1View.snp.right).offset(12)
            make.right.equalTo(line2View.snp.left).offset(-12)
            make.height.equalTo(17.0)
            make.top.equalTo(likeLabel)
        }
        collectLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        collectLabel.setContentHuggingPriority(.required, for: .horizontal)
        
        line2View.snp.makeConstraints { make in
            make.centerY.equalTo(likeLabel)
            make.size.equalTo(CGSize(width: 1, height: 12))
        }
        
        scanLabel.snp.makeConstraints { make in
            make.left.equalTo(line2View.snp.right).offset(12)
            make.right.equalTo(arrowImgView.snp.left)
            make.height.equalTo(17.0)
            make.top.equalTo(likeLabel)
        }
        scanLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        arrowImgView.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.centerY.equalToSuperview()
            make.right.equalTo(0)
        }
        
        vipLevel = .none
        update(count: 0, label: likeLabel)
        update(count: 0, label: collectLabel)
        update(count: 0, label: scanLabel)

    }
    
    @objc func enterBtnClicked() {
        enterClick?()
    }
    
    func updateAvatar() {
        let headImgName = YHLoginManager.shared.isLogin() ? "people_head_default" : "mine_head_logout"
        avarImgView.image = UIImage(named: headImgName)
    }
    
    func updateLikeCollectCount(_ model: YHCollectionModel) {
    
        update(count: model.myLikeCount, label: likeLabel)
        update(count: model.myCollectCount, label: collectLabel)
        update(count: model.myViewCount, label: scanLabel)
    }
    
    func update(count: Int, label: UILabel) {
        
        var text = ""
        let countStr = count < 10000 ? "\(count) " : String(format: "%.1fw ", Double(count/1000)/10.0)
         
        if label.tag == Self.likeTag {
            text = "点赞"
            
        } else if label.tag == Self.collectTag {
            text = "收藏"

        } else if label.tag == Self.scanTag {
            text = "最近浏览"
        }
        
        let attrStr = NSMutableAttributedString(string: "")
        
        let countAttrStr = NSAttributedString(
                                    string: countStr,
                                    attributes: [NSAttributedString.Key.foregroundColor: UIColor.mainTextColor,
                                                 NSAttributedString.Key.font: UIFont(name: "DINAlternate-Bold", size: 14)!])
        let titleAttrStr = NSAttributedString(
                                    string: text,
                                    attributes: [NSAttributedString.Key.foregroundColor: UIColor.init(hex: 0x435163),
                                                 NSAttributedString.Key.font: UIFont.PFSC_R(ofSize: 12)])
        attrStr.append(countAttrStr)
        attrStr.append(titleAttrStr)
        label.attributedText = attrStr
    }
    
    @objc func tap(gestureRecognizer: UITapGestureRecognizer) {
        if let view = gestureRecognizer.view {
            if view.tag == Self.likeTag {
                self.likeClick?()
                
            } else if view.tag == Self.collectTag {
                self.collectClick?()
            
            } else if view.tag == Self.scanTag {
                self.recentScanClick?()
            }
        }
    }
    
    @objc func didAvarImgViewTapped() {
        if let avatarClickBlock = avatarClickBlock {
            avatarClickBlock()
        }
    }
    
    @objc func didNickNameTapped() {
        if let nickNameClickBlock = nickNameClickBlock {
            nickNameClickBlock()
        }
    }
}
