//
//  YHEditHonorViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHEditHonorViewController: YHBaseViewController {
    var messageTextField: UITextView!
    var promptsLabel: UILabel!
    var numberLabel: UILabel!
    var nextButton: UIButton!
    var viewModel: YHEditViewModel = YHEditViewModel()
    var model: YHUserNameCardInfo = YHUserNameCardInfo()

    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        getData()
    }
    
    func getData() {
        viewModel.model = model
        messageTextField.text = model.honor
        if messageTextField.text.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
        numberLabel.text = messageTextField.text.count.string + "/200"
    }
    
    func setView() {
        gk_navTitle = "荣誉奖项"
        view.backgroundColor = .white
        
        let bgView = UIView()
        bgView.backgroundColor = UIColor(hex: 0xf8f8f8)
        bgView.layer.masksToBounds = true
        bgView.layer.cornerRadius = 6
        view.addSubview(bgView)
        bgView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.top.equalTo(20 + k_Height_NavigationtBarAndStatuBar)
            make.height.equalTo(276)
        }
        
        messageTextField = {
            let textField = UITextView()
            textField.backgroundColor = .clear
            textField.font = UIFont.PFSC_R(ofSize: 15)
            textField.delegate = self
            return textField
        }()
        view.addSubview(messageTextField)
        messageTextField.snp.makeConstraints { make in
            make.left.equalTo(29)
            make.right.equalTo(-29)
            make.top.equalTo(29 + k_Height_NavigationtBarAndStatuBar)
            make.height.equalTo(260)
        }
    
        promptsLabel = {
            let prompts = UILabel()
            prompts.font = UIFont.PFSC_R(ofSize: 14)
            prompts.textColor = UIColor.mainTextColor30
            prompts.text = "展示你的辉煌时刻，让更多见证你的卓越成就。"
            prompts.numberOfLines = 0
            return prompts
        }()
        view.addSubview(promptsLabel)
        promptsLabel.snp.makeConstraints { make in
            make.left.equalTo(34)
            make.right.equalTo(-34)
            make.top.equalTo(34 + k_Height_NavigationtBarAndStatuBar)
        }
        
        numberLabel = {
            let view = UILabel()
            view.text = "--/200"
            view.font = UIFont.PFSC_R(ofSize: 14)
            view.textColor = UIColor.mainTextColor30
            view.textAlignment = .right
            return view
        }()
        view.addSubview(numberLabel)
        numberLabel.snp.makeConstraints { make in
            make.height.equalTo(17)
            make.right.equalTo(-34)
            make.top.equalTo(265 + k_Height_NavigationtBarAndStatuBar)
        }
        nextButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 16)
            button.contentHorizontalAlignment = .center
            button.setTitle("保存", for: .normal)
            button.setTitleColor( UIColor(hex: 0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(nextStep), for: .touchUpInside)
            return button
        }()
        view.addSubview(nextButton)
        nextButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-8 - k_Height_safeAreaInsetsBottom())
            make.height.equalTo(48)
        }
        
    }
    
    @objc func nextStep() {
        viewModel.model.honor = messageTextField.text
        viewModel.requestSaveAward {[weak self] success, _ in
            guard let self = self else { return }
            if success {
                self.navigationController?.popViewController(animated: true)
            } else {
                YHHUD.flash(message: "保存失败")
            }
        }
    }
    
    override func backItemClick(_ sender: Any) {
        if viewModel.didChange {
            view.resignAllFirstResponders()
            YHCommonAlertView.show("", "您尚未保存修改，确定关闭吗？", "仍然关闭", "继续编辑", fullGuestureEnable: false) {
                self.navigationController?.popViewController()
            } callBack: {
            }
        } else {
            self.navigationController?.popViewController()
        }
    }
    
    /// 是否可以返回，包括点击返回和手势返回，默认YES
    override func navigationShouldPop() -> Bool {
        if viewModel.didChange {
            view.resignAllFirstResponders()
            YHCommonAlertView.show("", "您尚未保存修改，确定关闭吗？", "仍然关闭", "继续编辑", fullGuestureEnable: false) {
                self.navigationController?.popViewController()
            } callBack: {
            }
            return false
        }
        return true
    }
}

extension YHEditHonorViewController: UITextViewDelegate {
    func textViewDidChange(_ textView: UITextView) {
        if textView.text.count != 0 {
            promptsLabel.isHidden = true
        } else {
            promptsLabel.isHidden = false
        }
        numberLabel.text = textView.text.count.string + "/200"
    }
    func textView(_ textView: UITextView, shouldChangeTextIn range: NSRange, replacementText text: String) -> Bool {
        let newLength = (textView.text as NSString).length + text.count - range.length
        viewModel.didChange = true
        return newLength <= 200
    }
}
