//
//  YHIncomeTypePopViewSelectCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHIncomeTypePopViewSelectCell: UITableViewCell {

    static let cellReuseIdentifier = "YHIncomeTypePopViewSelectCell"
    
    var isCurrentSelected: Bool = false {
        didSet {
            checkIcon.image = isCurrentSelected ? UIImage(named: "income_type_check_btn_1") : UIImage(named: "income_type_check_btn_0")
            containerView.lineWidth = isCurrentSelected ? 1 : nil
            containerView.lineColor = isCurrentSelected ? UIColor.brandMainColor.cgColor : nil
        }
    }
    
    private lazy var checkIcon: UIImageView = { // income_type_check_btn_1
        let imageView = UIImageView(image: UIImage(named: "income_type_check_btn_0"))
        return imageView
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor(hexString: "#141414")
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var containerView: YHBaseCornerRadiusBorderView = {
        let view = YHBaseCornerRadiusBorderView.init(cornerRadius: 3, corner: .allCorners, lineWidth: nil, lineColor: nil)
        view.backgroundColor = .contentBkgColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, isSelected: Bool) {
        infoTitleLabel.text = title
        isCurrentSelected = isSelected
    }
    
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(containerView)
        containerView.addSubview(checkIcon)
        containerView.addSubview(infoTitleLabel)
        containerView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(21)
            make.right.equalToSuperview().offset(-21)
        }
        checkIcon.snp.makeConstraints { make in
            make.top.equalTo(infoTitleLabel.snp.top).offset(4)
            make.left.equalToSuperview().offset(16)
            make.width.height.equalTo(14)
        }
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(checkIcon.snp.right).offset(8)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
            make.right.lessThanOrEqualToSuperview().offset(-16)
        }
    }

}
