//
//  YHHomeInfoSectionCell.swift
//  galaxy
//
//  Created by edy on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHomeInfoSectionCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHHomeInfoSectionCell"
    
    lazy var titleLabel: UILabel =  {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 12)
        label.textAlignment = .left
        label.textColor = UIColor.mainTextColor70
        label.text = "身份福利"
        return label
    }()
    
    lazy var imgView: UIImageView = {
        let imgV = UIImageView(image: UIImage(named: "global_default_image"))
        imgV.clipsToBounds = true
        return imgV
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    func setupUI() {
        self.addSubview(self.imgView)
        self.addSubview(self.titleLabel)
        self.imgView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(self.imgView.snp.width)
        }
        self.titleLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(self.imgView.snp.bottom).offset(10)
            make.height.equalTo(20)
        }
    }
    
    func updateModel(_ model: YHHomeInfoClassifyModel) {
        self.titleLabel.text = model.name
        self.imgView.kf.setImage(with: URL(string: model.imgURL), placeholder: UIImage(named: "global_default_image"))

    }
}
