//
//  YHAdopterCardModel.swift
//  galaxy
//
//  Created by EDY on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHAdopterCardType {
    case travel  // 港澳通行证
    case china
    case resident
    case birth
    case id
    case other
    case marry
    case chinaTravel // 护照
    case chinaLife  // 中国居留许可签证
}

struct YHAdopterCardModel {
    var type: YHAdopterCardType = .travel
    var title: String = ""
    var state: Int = 0 // 0 1 2 3 待上传 审核中 已通过 已驳回
    
    init(type: YHAdopterCardType, title: String, state: Int) {
        self.type = type
        self.title = title
        self.state = state
    }
}
