//
//  YHResignFamilyInfoListCell.swift
//  galaxy
//
//  Created by edy on 2024/10/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

enum YHResignFamilyInfoType: Int {
    case none = 0
    case mainApplicantName = 1
    case firstName = 2
    case lastName = 3
    case marriage = 4
    case declareNation = 5
    case occupation = 6
    case hongKongId = 7
    case hongkongAddress = 8
    case travelCertificateType = 9
    case travelCertificateId = 10
    case childName = 11
    case spouseName = 12
    case certificateValidTime = 13
}

enum YHResignFamilyInfoActionType: Int {
    case none = 0
    case edit = 1    // 输入框编辑
    case select = 2  // 弹出弹窗选择
    case changeValidTime // 有效期不足去处理
}

class YHResignFamilyInfoOption {
    var value: String = ""
    var index: Int = -1
    var isSelect: Bool = false
    
    init(index: Int, value: String, isSelect: Bool) {
        self.index = index
        self.value = value
        self.isSelect = isSelect
    }
}

class YHResignFamilyInfoItem {
    
    var id: YHResignFamilyInfoType = .none
    var action: YHResignFamilyInfoActionType = .none
    var isMust: Bool = false
    var title: String = ""
    var value: String = ""
    var previousTitle: String = ""
    var previousValue: String = ""
    var options: [YHResignFamilyInfoOption] = []
    var isEditMode: Bool = false
    var isShowPreviousInfo: Bool = false
    var valueIndex: Int = -1
    
    var tips: String {
        get {
            return self.getRedTips()
        }
    }
    
    func getRedTips() -> String {

        if !self.value.isEmpty {  // value不为空
            if self.id == .hongKongId, !self.value.isHKIdentityCardNumber() {
                return "请输入正确的香港身份证号"
            }
            if self.id == .marriage {
                if let marriageOptions = YHSheetPickerView.dataSource[.marriage1] {
                    let options =  marriageOptions.map {
                        return "\($0.index)"
                    }
                    if !options.contains("\(self.valueIndex)") {
                        return "请选择婚姻状况"
                    }
               }
            }
            return ""
        }
        
        if self.isMust == false { // 非必填
            return ""
        }
        
        // 必填
        // value 为空的情况
        if self.id == .mainApplicantName {
            return "请输入主申人姓名"
        }
            
        if self.id == .spouseName {
            return "请输入配偶姓名"
        }
        
        if self.id == .childName {
            return "请输入子女姓名"
            
        } else if self.id == .firstName {
            return "请输入姓(拼音)"
            
        } else if self.id == .lastName {
            return "请输入名(拼音)"
            
        } else if self.id == .occupation {
            return "请输入职业"
            
        } else if self.id == .hongKongId {
            return "请输入香港身份证号"
        
        } else if self.id == .hongkongAddress {
            return "请输入香港住址"
        
        } else if self.id == .marriage {
            return "请选择婚姻状况"
        }
        return ""
    }
    
    required init() {
        
    }
    
    init(id: YHResignFamilyInfoType, action: YHResignFamilyInfoActionType, isMust: Bool, title: String, value: String, previousTitle: String, previousValue: String, options: [YHResignFamilyInfoOption] = [], isEditMode: Bool, isShowPreviousInfo: Bool) {
        self.id = id
        self.action = action
        self.isMust = isMust
        self.title = title
        self.value = value
        self.previousTitle = previousTitle
        self.previousValue = previousValue
        self.isEditMode = isEditMode
        self.isShowPreviousInfo = isShowPreviousInfo
        self.options = options
    }
}

class YHResignFamilyInfoListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHResignFamilyInfoListCell"
    var familyInfo = YHResignInfoConfirmFamilyModel()
    
    var isEditState: Bool = false {
        didSet {
            let text = self.isEditState ? "完成" : "修改"
            self.modifyBtn.setTitle(text, for: .normal)
        }
    }
    
    var clickUnvalidTime: (() -> Void)?
    
    // 是否进入编辑模式
    var editBlock: ((Bool) -> Void)?
    // 更新姓名拼音
    var updateNamePinYinBlock: (() -> Void)?
    // 选择出生国家
    var selectBirthNation: ((Bool) -> Void)?
    // 姓名更改
    var updateName: ((String) -> Void)?
    var updateList: (() -> Void)?

    var items: [YHResignFamilyInfoItem] = []
    
    lazy var whiteView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        return label
    }()
    
    lazy var modifyBtn: UIButton = {
        let btn = UIButton()
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.brandMainColor, for: .normal)
        btn.setTitle("修改", for: .normal)
        btn.addTarget(self, action: #selector(didModifyBtnClicked), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 15, left: 15, bottom: 15, right: 15)
        return btn
    }()
    
    lazy var itemsContentView: UIView = {
        let view = UIView()
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    @objc func didModifyBtnClicked() {
        editBlock?(!self.isEditState)
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteView)
        whiteView.addSubview(titleLabel)
        whiteView.addSubview(modifyBtn)
        whiteView.addSubview(itemsContentView)
        
        whiteView.snp.makeConstraints { make in
            make.top.equalTo(16.0)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.height.equalTo(24.0)
        }
        
        modifyBtn.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.right.equalTo(-18)
            make.size.equalTo(CGSize(width: 28, height: 20))
        }
        
        itemsContentView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.bottom.equalTo(0)
        }

    }
    
    func updateItems(_ items: [YHResignFamilyInfoItem]) {
        self.items =  items
        itemsContentView.removeSubviews()
        
        var lastItemView: UIView?
        for (index, item) in items.enumerated() {
            var itemView: UIView? = YHResignInfoItemView(frame: .zero)
            if item.id == .certificateValidTime {
                itemView = YHResignInfoValidTimeItemView(frame: .zero)
            }
            if let itemView = itemView as? YHResignInfoItemView {
                itemsContentView.addSubview(itemView)
                itemView.updateItem(item, familyInfo: familyInfo)
                itemView.updateLineMargin(index == 0 ? -18.0 : 0)
                itemView.updateList = {
                    [weak self] in
                    guard let self = self else { return }
                    self.updateList?()
                }
                itemView.updateNamePinYinBlock = {
                    [weak self] in
                    guard let self = self else { return }
                    self.updateNamePinYinBlock?()
                }
                
            } else if let itemView = itemView as? YHResignInfoValidTimeItemView {
                itemsContentView.addSubview(itemView)
                itemView.updateItem(item, familyInfo: familyInfo)
                itemView.clickUnvalidTime = {
                    [weak self] in
                    guard let self = self else { return }
                    clickUnvalidTime?()
                }
            }
            
            if let itemView = itemView {
                itemView.snp.makeConstraints { make in
                    make.left.right.equalTo(0)
                    if let lastView = lastItemView {
                        make.top.equalTo(lastView.snp.bottom)
                    } else {
                        make.top.equalTo(itemsContentView.snp.top)
                    }
                    
                    if index == items.count-1 {
                        make.bottom.equalTo(itemsContentView.snp.bottom)
                    }
                }
                lastItemView = itemView
            }
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }

}
