//
//  YHWorkFileSyncTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkFileSyncTableViewCell: UITableViewCell {

    typealias ExperienceListBlock = (_ model: YHWorkExperienceFileModel, _ type: YHWorkFileClickType) -> Void
    typealias AddIntroductionBlock = () -> Void
    var experienceListBlock: ExperienceListBlock?
    var addIntroductionBlock: AddIntroductionBlock?
    var selectIntroductionBlock: AddIntroductionBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var mainItemView: UIView!
    var bottomView: YHWorkItemAddView!
    var selectbottomView: YHWorkItemAddView!
    var dataSource: [YHWorkExperienceFileModel]? {
        didSet {
            updateAllViews()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 17)
            label.text = "工作相关文件"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-18)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.text = "快捷导入简历等文件，提升文书定制的丰富度和完善度"
            label.textColor = UIColor.labelTextColor2
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(42)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        centerView.addSubview(line)
        line.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(78)
            make.height.equalTo(0.5)
            make.right.equalTo(-18)
        }
        
        mainItemView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        centerView.addSubview(mainItemView)
        mainItemView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-79)
            make.top.equalTo(79)
        }
        
        bottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("新增上传".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.addIntroductionBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.bottom.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(45)
            make.right.equalTo(centerView.snp.centerX).offset(-5)
        }
        
        selectbottomView = {
            let view = YHWorkItemAddView()
            view.addBtn.setTitle("选择已有".local, for: .normal)
            view.clickBlock = {[weak self] in
                guard let self = self else { return }
                if let block = self.selectIntroductionBlock {
                    block()
                }
            }
            return view
        }()
        centerView.addSubview(selectbottomView)
        selectbottomView.snp.makeConstraints { make in
            make.right.bottom.equalTo(-18)
            make.left.equalTo(centerView.snp.centerX).offset(5)
            make.height.equalTo(45)
        }
    }
    
    func updateAllViews() {
        mainItemView.removeSubviews()
        for i in 0 ..< (dataSource?.count ?? 0) {
            let itemView = YHWorkFileItemView()
            itemView.dataSource = dataSource?[i]
            itemView.block = {[weak self] model, type in
                guard let self = self else { return }
                if let block = self.experienceListBlock {
                    block(model, type)
                }
            }
            mainItemView.addSubview(itemView)
            itemView.snp.makeConstraints { make in
                make.left.right.equalToSuperview()
                make.top.equalTo(69 * i)
                make.height.equalTo(69)
            }
        }
    }
    
    @objc func cannal() {
        
    }
    
    @objc func more() {
        
    }
}
