//
//  YHHKRecordsCustomerItemCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsCustomerItemCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHHKRecordsCustomerItemCell"
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 17)
        label.textColor = UIColor(hexString: "#222222")
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor50
        label.font = .PFSC_R(ofSize: 14)
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, detail: String?) {
        infoTitleLabel.text = title
        infoDetailLabel.text = detail
    }
    
}

extension YHHKRecordsCustomerItemCell {
    
    private func setupUI() {
        updateCellCorner(.top)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(bottomLineView)
        
        infoTitleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-12)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(6)
            make.centerY.equalTo(infoTitleLabel)
            make.right.equalToSuperview().offset(-18)
        }
        
    }
}
