//
//  YHActivityDetailBottomView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityDetailBottomView: UIView {
    static let viewH: CGFloat = 98.0
    
    var dataModel: YHActivityDetailModel? {
        didSet {
            updateUI()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: YHBasicInfoFillBottomView.viewH))
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    typealias Block = (Int) -> Void
    var block: Block?
    var saveButton: UIButton!
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
}

private extension YHActivityDetailBottomView {
    
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        if let status = Int(model.status) {
            isHidden = false
            saveButton.setTitle(YHActivityStatus.init(rawValue: status)?.titleForDetail, for: .normal)
            saveButton.backgroundColor = YHActivityStatus.init(rawValue: status)?.activityColor
        } else {
            isHidden = true
        }
    }
    
    func setupUI() {
        
        backgroundColor = .white
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(1)
        }
        
        saveButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("立即报名", for: .normal)
            button.setTitleColor(UIColor.white, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(save), for: .touchUpInside)
            return button
        }()
        addSubview(saveButton)
        saveButton.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(bottomLine.snp.bottom).offset(8)
            make.height.equalTo(48)
        }
    }
    
    @objc func save() {
        block?(0)
    }
}
