//
//  YHLifeItemTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHLifeItemTableViewCell: UITableViewCell {
    var centerImageView: UIImageView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var dataSource: YHProductModel? {
        didSet {
            guard let dataSource = dataSource else { return }
            self.titleLabel.text =  dataSource.name
            self.subTitleLabel.text = dataSource.description
            guard let url = URL(string: dataSource.image) else { return }
            self.centerImageView.kf.setImage(with: url)
        }
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        self.backgroundColor = .white
        centerImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "global_default_image")
            return imageView
        }()
        contentView.addSubview(centerImageView)
        centerImageView.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(20)
            make.height.width.equalTo(100)
        }
        
        titleLabel = {
            let view = UILabel()
            view.font = UIFont.PFSC_M(ofSize: 17)
            view.textColor = UIColor.mainTextColor
            view.numberOfLines = 2
            return view
        }()
        contentView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(144)
            make.right.equalTo(-20)
            make.top.equalTo(20)
        }
        
        subTitleLabel = {
            let view = UILabel()
            view.font = UIFont.PFSC_R(ofSize: 14)
            view.textColor = UIColor.mainTextColor50
            view.numberOfLines = 2
            return view
        }()
        contentView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(144)
            make.right.equalTo(-20)
            make.top.equalTo(titleLabel.snp.bottom).offset(8.0)
        }
    }

}
