//
//  YHUploadCertificateDateItem.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHUploadCertificateDateItem: UIView {
    
    static let viewH: CGFloat = 20.0 + 16*2
    
    var needCheckMustFlag: Bool = false {
        didSet {
            checkMustStatus()
        }
    }
    
    private lazy var cardLabel: UILabel = {
        let lable = UILabel()
        lable.text = "入境日期"
        lable.font = .PFSC_R(ofSize: 14)
        lable.textColor = UIColor.mainTextColor
        return lable
    }()
    
    private lazy var redTipsLabel: UILabel = {
        let lable = UILabel()
        lable.text = "请选择入境日期"
        lable.font = .PFSC_R(ofSize: 10)
        lable.textColor = UIColor.failColor
        lable.isHidden = true
        return lable
    }()
    
    lazy var dateTextField: UITextField = {
        let textField = UITextField()
        textField.backgroundColor = .clear
        textField.attributedPlaceholder = NSAttributedString(string: "请输入".local, attributes: [NSAttributedString.Key.foregroundColor: UIColor.mainTextColor30])
        textField.font = UIFont.PFSC_M(ofSize: 14)
        textField.tintColor = UIColor.brandMainColor
        textField.textColor = UIColor.mainTextColor
        textField.isEnabled = false
        return textField
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var statusImageView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "grey_right_arrow"))
        return view
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
}

private extension YHUploadCertificateDateItem {
    func checkMustStatus() {
        if needCheckMustFlag {
            
            if dateTextField.text?.isEmpty == true {
                redTipsLabel.isHidden = false
            } else {
                redTipsLabel.isHidden = true
            }
            
        } else {
            redTipsLabel.isHidden = true
        }
    }
    
    func setupUI() {
        
        addSubview(cardLabel)
        cardLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.equalToSuperview()
            make.height.equalTo(20)
        }
        
        let a: ASAttributedString = .init("*", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.failColor))
        let b: ASAttributedString = .init(" 入境日期", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        cardLabel.attributed.text = a + b
        
        addSubview(dateTextField)
        dateTextField.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(cardLabel.snp.right).offset(48)
        }
        
        addSubview(statusImageView)
        statusImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.width.equalTo(20)
        }
        
        addSubview(redTipsLabel)
        redTipsLabel.snp.makeConstraints { make in
            make.top.equalTo(cardLabel.snp.bottom)
            make.left.equalToSuperview()
            make.height.equalTo(10)
        }
        
        addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(1)
        }
    }
}

extension YHUploadCertificateDateItem {
    func update(title: String, isMust: Bool = true, hideLineFlag: Bool = true) {
        if isMust {
            let a: ASAttributedString = .init("*", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.failColor))
            let b: ASAttributedString = .init(NSAttributedString(string: title), .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            cardLabel.attributed.text = a + b
            redTipsLabel.text = "请选择" + title
            
        } else {
            let b: ASAttributedString = .init(NSAttributedString(string: title), .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
            cardLabel.attributed.text = b
        }
        
        lineView.isHidden = hideLineFlag
    }
    
    func updateDate(date: String) {
        dateTextField.text = date
        checkMustStatus()
    }
}
