//
//  YHCertificateFilterItemCell.swift
//  galaxy
//
//  Created by edy on 2024/3/13.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateFilterItemCell: UICollectionViewCell {
    
    static let cellReuseIdentifier = "YHCertificateFilterItemCell"
    private let titleSelectColor = UIColor.brandMainColor
    private let titleDefaultColor = UIColor.mainTextColor
    private let btnSelectFont = UIFont.PFSC_M(ofSize: 13)
    private let btnDefaultFont = UIFont.PFSC_R(ofSize: 13)

    var title: String? {
        didSet {
            contentBtn.setTitle(title, for: .normal)
        }
    }
    
    var isSelect: Bool = false {
        didSet {
            contentBtn.layer.borderColor = (isSelect ? titleSelectColor : .clear).cgColor
            contentBtn.setTitleColor((isSelect ? titleSelectColor : titleDefaultColor), for: .normal)
            contentBtn.titleLabel?.font = (isSelect ? btnSelectFont : btnDefaultFont)
        }
    }
    
    lazy var contentBtn: UIButton = {
        let btn = UIButton()
        btn.setTitle("", for: .normal)
        btn.titleLabel?.font = btnDefaultFont
        btn.setTitleColor(titleDefaultColor, for: .normal)
        btn.backgroundColor = UIColor(hexString: "#F8F9FB")
        btn.layer.cornerRadius = YHCertificateFilterView.itemHeight/2.0
        btn.layer.borderWidth = 1.0
        btn.isEnabled = false
        return btn
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        contentView.addSubview(contentBtn)
        contentBtn.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
}
