//
//  YHCertificateTemplateCell.swift
//  galaxy
//
//  Created by edy on 2024/3/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateSampleTemplateView: UIView {
    
    lazy var iconImgV: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "my_cer_template"))
        return imgView
    }()
    
    lazy var arrowImgV: UIImageView = {
        let imgView = UIImageView(image: UIImage(named: "form_right_arrow"))
        return imgView
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.text = "查看证件示例模板".local
        label.textColor = UIColor.mainTextColor
        label.textAlignment = .left
        label.font = UIFont.PFSC_B(ofSize: 14)
        return label
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.backgroundColor = .contentBkgColor
        self.layer.cornerRadius = kCornerRadius6
        self.clipsToBounds = true
        
        self.addSubview(iconImgV)
        self.addSubview(titleLabel)
        self.addSubview(arrowImgV)
        
        iconImgV.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.centerY.equalToSuperview()
            make.left.equalToSuperview().offset(16)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.height.equalTo(20)
            make.centerY.equalToSuperview()
            make.left.equalTo(iconImgV.snp.right).offset(12)
            make.right.equalTo(arrowImgV.snp.left).offset(-5)
        }
        
        arrowImgV.snp.makeConstraints { make in
            make.width.height.equalTo(20)
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-13)
        }
    }
}

class YHCertificateTemplateCell: UITableViewCell {

    static let cellReuseIdentifier = "YHCertificateTemplateCell"
    var templatePath: YHMaterialPath? {
        didSet {
            if let path = templatePath {
                
                var title = "查看证件示例模板"
                if path.type == 1 { // 指引
                    title = "查看证件操作指引"
                }
                templateView.titleLabel.text = title
            }
        }
    }
    
    var templateModel: YHResignTemplateItemModel? {
        didSet {
            if let model = templateModel {
                if !model.name.isEmpty {
                    templateView.titleLabel.text = model.name

                } else {
                    templateView.titleLabel.text = "查看资料示例模板"
                }
            } else {
                templateView.titleLabel.text = "查看资料示例模板"
            }
        }
    }
    
    var resignUploadDetailTemplateListModel: YHResignUploadDetailTemplateListModel? {
        didSet {
            if let model = resignUploadDetailTemplateListModel {
                if !model.name.isEmpty {
                    templateView.titleLabel.text = model.name

                } else {
                    templateView.titleLabel.text = "查看资料示例模板"
                }
            } else {
                templateView.titleLabel.text = "查看资料示例模板"
            }
        }
    }
    
    lazy var templateView: YHCertificateSampleTemplateView = {
        let view = YHCertificateSampleTemplateView(frame: CGRect.zero)
        return view
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        createUI()
    }
    
    func createUI() {
    
        self.selectionStyle = .none
        
        contentView.addSubview(templateView)
        templateView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.top.bottom.equalToSuperview()
        }
    }
    
    func update(bottomMargin: CGFloat) {
        templateView.snp.updateConstraints { make in
            make.bottom.equalToSuperview().offset(-bottomMargin)
        }
    }

}
