//
//  YHLookResignResultStateOneTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHLookResignResultStateOneTableViewCell: UITableViewCell {
    static let cellReuseIdentifier = "YHLookResignResultStateOneTableViewCell"

    typealias ExperienceListBlock = (_ model: YHResignUploadDocModel, _ section: Int) -> Void
    var clickBlock: ExperienceListBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var peopleLabel: UILabel!
    var peopleValueLabel: UILabel!
    var docLabel: UILabel!
    var docValueLabel: UILabel!
    var mainItemView: UIView!
    var lineView: UIView!
    var subLineView: UIView!
    
    var title: String = "" {
        didSet {
            titleLabel.text = title
        }
    }
    var dataSource: YHLookResignResultDataDataModel? {
        didSet {
            updateAllViews()
        }
    }
    
    lazy var previewFileTool: YHFilePreviewTool = {
        let tool = YHFilePreviewTool(targetVC: UIViewController.current)
       return tool
    }()

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(0)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.text = "第一批"
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.right.equalTo(-20)
        }
    
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(52)
            make.height.equalTo(0.5)
        }
        
        peopleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "申请人："
            label.textColor = UIColor.mainTextColor50
            return label
        }()
        centerView.addSubview(peopleLabel)
        peopleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(68)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        peopleValueLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "张三丰、章一刀"
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .right
            return label
        }()
        centerView.addSubview(peopleValueLabel)
        peopleValueLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(68)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        docLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.text = "递交回执："
            label.textColor = UIColor.mainTextColor50
            return label
        }()
        centerView.addSubview(docLabel)
        docLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(104)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        docValueLabel = {
            let label = UILabel()
            label.textColor = UIColor.mainTextColor
            let a = ASAttributedString.init("欧阳先生", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.brandMainColor), .underline(.single), .action {
                // 点击预览
            })
            label.attributed.text = a
            label.textAlignment = .right
            return label
        }()
        centerView.addSubview(docValueLabel)
        docValueLabel.snp.makeConstraints { make in
            make.top.equalTo(104)
            make.height.equalTo(20)
            make.right.equalTo(-18)
        }
        
        subLineView = {
            let view = UIView()
            view.backgroundColor = UIColor(hex: 0xff8000)
            view.layer.cornerRadius = 1
            return view
        }()
        centerView.addSubview(subLineView)
        subLineView.snp.makeConstraints { make in
            make.right.equalTo(docValueLabel.snp.left).offset(-8)
            make.centerY.equalTo(docValueLabel.snp.centerY)
            make.width.height.equalTo(4)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        var names = ""
        var i = 0
        for item in dataSource.users {
            if i == 0 {
                names += item
            } else {
                names = names + "、" + item
            }
            i += 1
        }
        peopleValueLabel.text = names
        if dataSource.result_file.count != 0 {
            let a = ASAttributedString.init("递交凭证.pdf", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor.brandMainColor), .underline(.single), .action {
                // 点击预览
                let viewModel = YHBaseViewModel()
                viewModel.getRealUsefulUrl(dataSource.result_file) { success in
                    self.previewFileTool.openXLSXRemoteFile(urlString: success, fileName: "")
                }
            })
            docValueLabel.attributed.text = a
            subLineView.isHidden = true
        } else {
            let a = ASAttributedString.init("待递交", .font(UIFont.PFSC_M(ofSize: 14)), .foreground(UIColor(hex: 0xff8000)))
            docValueLabel.attributed.text = a
            subLineView.isHidden = false
        }
    }

}
