//
//  YHResignInfoValidTimeItemView.swift
//  galaxy
//
//  Created by edy on 2024/10/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

// 文字编辑和选择弹窗时使用
class YHResignInfoValidTimeItemView: UIView {

    var clickUnvalidTime: (() -> Void)?
    private var debounceTimer: Timer?
    
    var item: YHResignFamilyInfoItem = YHResignFamilyInfoItem()
    var faimilyInfo = YHResignInfoConfirmFamilyModel()

    let viewModel = YHResignInfoConfirmViewModel()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 14)
        label.textColor = UIColor.mainTextColor
        return label
    }()
    
    lazy var errorTipsLabel = {
        let errorTipsLabel = UILabel()
        errorTipsLabel.font = UIFont.PFSC_R(ofSize: 12)
        errorTipsLabel.textColor = UIColor.failColor
        errorTipsLabel.text = "证件有效期不足"
        return errorTipsLabel
    }()
    
    lazy var grayContentView: UIView = {
        
        let view = UIView()
        view.layer.cornerRadius = kCornerRadius6
        view.backgroundColor = UIColor(hex: 0xF8F9FB)
        let tap = UITapGestureRecognizer(target: self, action: #selector(didUnvalidTimeClicked))
        view.addGestureRecognizer(tap)
        view.clipsToBounds = true
        
        view.addSubview(errorTipsLabel)
        
        let arrowImgV = UIImageView(image: UIImage(named: "file_list_right_arrow_blue"))
        view.addSubview(arrowImgV)
        
        let handleLabel = UILabel()
        handleLabel.font = UIFont.PFSC_R(ofSize: 12)
        handleLabel.textColor = UIColor.brandMainColor
        handleLabel.textAlignment = .right
        handleLabel.text = "去更新"
        view.addSubview(handleLabel)
        
        errorTipsLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.centerY.equalToSuperview()
            make.height.equalTo(18)
        }
        
        arrowImgV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.width.height.equalTo(20)
            make.right.equalTo(-16)
        }

        handleLabel.snp.makeConstraints { make in
            make.right.equalTo(arrowImgV.snp.left).offset(0)
            make.centerY.equalToSuperview()
            make.height.equalTo(18)
        }

        return view
    }()
    
    @objc func didUnvalidTimeClicked() {
        clickUnvalidTime?()
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(lineView)
        self.addSubview(titleLabel)
        self.addSubview(detailLabel)
        self.addSubview(grayContentView)
       
        lineView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(0)
            make.height.equalTo(20)
            make.width.equalTo(122)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(titleLabel.snp.right)
            make.right.equalTo(-18)
        }
    
        grayContentView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(detailLabel.snp.bottom).offset(16)
            make.bottom.equalTo(-16)
            make.height.equalTo(42)
        }
    }
    
    func updateItem(_ item: YHResignFamilyInfoItem, familyInfo: YHResignInfoConfirmFamilyModel) {
        self.item = item
        self.faimilyInfo = familyInfo
        // 标题
        var title: ASAttributedString = .init("\(item.title)", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.mainTextColor))
        // 是否必填
        if item.isMust {
            let mustTag: ASAttributedString = .init("*", .font(UIFont.PFSC_R(ofSize: 14)), .foreground(UIColor.failColor))
            title = mustTag + title
        }
        
        titleLabel.attributed.text = title
        detailLabel.text = item.value
        
        detailLabel.snp.remakeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(titleLabel.snp.right)
            make.right.equalTo(-18)
            make.height.greaterThanOrEqualTo(20)
        }
        
        // 是否隐藏红色提示语灰色视图
        var isNeedHiddenGrayView = true
        if let identity = familyInfo.identity {
            if identity.number.isEmpty {
                isNeedHiddenGrayView = false
                errorTipsLabel.text = "证件号缺失"
                errorTipsLabel.textColor = .failColor
                
            } else if !identity.isValidDateEnough() {
                isNeedHiddenGrayView = false
                errorTipsLabel.text = "证件有效期不足"
                errorTipsLabel.textColor = .failColor
                
            } else {
                isNeedHiddenGrayView = false
                errorTipsLabel.text = "证件有效期正常"
                errorTipsLabel.textColor = UIColor.init(hex: 0x8993A2)
            }
        }
        grayContentView.isHidden = isNeedHiddenGrayView
        grayContentView.snp.remakeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(detailLabel.snp.bottom).offset(isNeedHiddenGrayView ? 0 : 16)
            make.bottom.equalTo(-16)
            make.height.equalTo(isNeedHiddenGrayView ? 0 : 42)
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
}
