//
//  YHResignUploadDetailModel.swift
//  galaxy
//
//  Created by EDY on 2024/10/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHResignUploadDetailModel: SmartCodable {
    var is_required: Bool = false // 是否必需
    var name: String = ""         // 文书名称
    var status: Int = 0           // 状态 0:审核中;1:已完成;2:已驳回;3:待上传
    var description: String = ""
    var unavailable_reason: String = ""
    var reject_reason: String = ""
    var template_list: [YHResignUploadDetailTemplateListModel] = []
    var file_list: [YHResignUploadDetailFileListModel] = []

    required init() {
        
    }
}

class YHResignUploadDetailTemplateListModel: SmartCodable {
    var name: String = ""
    var url: String = ""
    required init() {
        
    }
}

class YHResignUploadDetailFileListModel: SmartCodable {
    var name: String = ""
    var url: String = ""
    var updated_at: String = ""
    required init() {
        
    }
    
    // 获取文件后缀名 eg:123.pdf -> pdf
    func getFileSuffixName() -> String {
        let res1 = url.pathExtension.lowercased()
        if !res1.isEmpty {
            return res1
        }
        let res2 = name.pathExtension.lowercased()
        if !res2.isEmpty {
            return res2
        }
        return ""
    }
    
    func getFileNameWithoutSuffix() -> String {
        if name.isEmpty {
            return name
        }
        if !name.contains(".") {
            return name
        }
        if !name.pathExtension.isEmpty {
          let fileName = (name as NSString).deletingPathExtension
          return fileName
        }
        return ""
    }
}
