//
//  YHBasicInfoFillCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/3.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHBasicInfoFillCell: UITableViewCell {
    static let cellReuseIdentifier = "YHBasicInfoFillCell"
    
    var dataModel: YHBasicInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
    var indexPath: IndexPath?
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    typealias Block = (IndexPath?) -> Void
    var block: Block?
}

extension YHBasicInfoFillCell {
    func updateUI() {
        guard let dataModel = dataModel else { return}
        contentView.removeSubviews()
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        // 主申请人
        let holdView1 = UIView()
        holdView1.backgroundColor = .white
        holdView1.layer.cornerRadius = kCornerRadius6
        holdView1.clipsToBounds = true
        contentView.addSubview(holdView1)
        
        holdView1.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview()
        }
        
        let sessionView = YHPreviewInfoSingleLineTitleView()
        sessionView.updateTitle(title: dataModel.sessionTitle)
        holdView1.addSubview(sessionView)
        sessionView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.right.equalToSuperview().offset(0)
            make.left.equalToSuperview().offset(0)
            make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
        }
        
        let arrQ = dataModel.arrQuestionItem
        var tmpView: UIView = sessionView
        
        for (index0, question) in arrQ.enumerated() {
            let view = YHBasicInfoFillView()
            view.block = {
                self.block?(self.indexPath)
            }
            view.model = question
            holdView1.addSubview(view)
            
            if arrQ.count == 1 {
                view.snp.makeConstraints { make in
                    make.top.equalTo(tmpView.snp.bottom)
                    make.right.equalToSuperview().offset(-18)
                    make.left.equalToSuperview().offset(18)
                    make.bottom.equalToSuperview()
                }
            } else {
                
                if index0 == arrQ.count - 1 {
                    view.snp.makeConstraints { make in
                        make.top.equalTo(tmpView.snp.bottom)
                        make.right.equalToSuperview().offset(-18)
                        make.left.equalToSuperview().offset(18)
                        make.bottom.equalToSuperview()
                    }
                } else {
                    view.snp.makeConstraints { make in
                        make.top.equalTo(tmpView.snp.bottom)
                        make.right.equalToSuperview().offset(-18)
                        make.left.equalToSuperview().offset(18)
                    }
                }
            }
            tmpView = view
        }
    }
}
