//
//  YHCertificateEntryCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateEntryCell: UITableViewCell {
    static let cellReuseIdentifier = "YHCertificateEntryCell"
    static let cellH: CGFloat = 68.0
    
    var dataModel: YHCategoryData? {
        didSet {
            updateUI()
        }
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var contractNameLable = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.font = UIFont.PFSC_M(ofSize: 16)
        lable.text = "主申请人（张三）"
        return lable
    }()
    
    lazy var contractIdLable = {
        let lable = UILabel()
        lable.textColor = UIColor.labelTextColor2
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.text = "已完成"
        lable.textAlignment = .right
        return lable
    }()
}

extension YHCertificateEntryCell {
    func updateUI() {
        guard let dataModel = dataModel else { return }
        var name = ""
        if dataModel.userName.isEmpty == false {
            name = "(" + dataModel.userName + ")"
        }
        contractNameLable.text = dataModel.applicantName + name
        
        // 0：未审核，1：通过 2：驳回,3：未提交',
        var title = ""
        var color: UIColor = .failColor
        if dataModel.checkStatus == 0 {
            title = "审核中"
            color = UIColor.warnColor
        } else if dataModel.checkStatus == 1 {
            title = "已完成"
            color = UIColor(hex: 0x3CC694)
            
        } else if dataModel.checkStatus == 2 {
            title = "已驳回"
            color = UIColor.failColor
        } else if dataModel.checkStatus == 3 {
            title = "待上传"
            color = UIColor.brandMainColor
        } else {
            title = "--"
            color = UIColor.brandMainColor
        }
        contractIdLable.text = title
        contractIdLable.textColor = color
    }
    
    func setupUI() {
        let holdView = UIView()
        holdView.backgroundColor = .white
        holdView.layer.cornerRadius = kCornerRadius6
        holdView.clipsToBounds = true
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(holdView)
        holdView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
        }
        
        let nextImgV = UIImageView()
        nextImgV.image = UIImage(named: "service_center_right_next_icon")
        nextImgV.contentMode = .scaleAspectFill
        holdView.addSubview(nextImgV)
        nextImgV.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-26)
            make.width.height.equalTo(kMargin)
        }
        
        holdView.addSubview(contractIdLable)
        contractIdLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(nextImgV.snp.left).offset(-2)
            make.width.equalTo(50)
            make.height.equalTo(20)
        }
        
        holdView.addSubview(contractNameLable)
        contractNameLable.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.left.equalTo(21)
            make.right.equalTo(contractIdLable.snp.left).offset(-10)
            make.height.equalTo(24)
        }
    }
}
