//
//  YHMsgListModel.swift
//  galaxy
//
//  Created by edy on 2024/4/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHMessageType: Int {
    case none = 0
    case infoFill = 1   // 资料填写
    case cerUpload = 2  // 证件上传
    case draft = 3      // 文书定稿
    case fileSign = 4   // 文件签字
    case infoSubmit = 5 // 资料递交
    case identityApproved = 6 // 身份获批
    case goToHK = 7 // 赴港办证
    case renewal = 8 // 身份续签
    case business = 9 // 商务
    case article = 10 // 资讯
    case trip = 11 // 礼物
    
    case yinheManager = 9527 // 银河管家
    case txIM = 9528 // im聊天
}

class YHMessageInfoModel: SmartCodable {
    var unreadCount: Int = 0
    var lastMessage: String = ""
    var lastMessageTime: Int64 = 0
    var type: Int = 0
    var title: String = ""
    var avatar: String = ""
    var conversationID: String = ""
    var userID: String = ""
    var groupID: String = ""
    var orderKey: Int64 = 0
    var isPinned: Bool = false
    var isNotDisturb: Bool = false
    var isOnline: Bool = false
    var draftText: String = ""
    var attributedSubtitle: NSAttributedString = NSAttributedString()
    var avatarImage: UIImage?
    var groupType: String = ""
        
    required init() {
        
    }
    
    init(
        unreadCount: Int = 0,
        lastMessage: String = "",
        lastMessageTime: Int64 = 0,
        type: Int = 0,
        title: String = "",
        avatar: String = "",
        conversationID: String = "",
        userID: String = "",
        groupID: String = "",
        orderKey: Int64 = 0,
        isPinned: Bool = false,
        isNotDisturb: Bool = false,
        isOnline: Bool = false,
        draftText: String = "",
        attributedSubtitle: NSAttributedString = NSAttributedString(),
        avatarImage: UIImage?,
        groupType: String
    ) {
        self.unreadCount = unreadCount
        self.lastMessage = lastMessage
        self.lastMessageTime = lastMessageTime
        self.type = type
        self.title = title
        self.avatar = avatar
        self.conversationID = conversationID
        self.userID = userID
        self.groupID = groupID
        self.orderKey = orderKey
        self.isPinned = isPinned
        self.isNotDisturb = isNotDisturb
        self.isOnline = isOnline
        self.draftText = draftText
        self.attributedSubtitle = attributedSubtitle
        self.avatarImage = avatarImage
        self.groupType = groupType
    }

    enum CodingKeys: String, CodingKey {
        case unreadCount = "unread_count"
        case lastMessage = "last_message"
        case lastMessageTime = "last_message_time"
        case type = "type"
    }
    
    func getTitle() -> String {
        
        if type == YHMessageType.yinheManager.rawValue {
            return "银河管家"
            
        } else if type == YHMessageType.infoFill.rawValue {
            return "资料填写"
            
        } else if type == YHMessageType.cerUpload.rawValue {
            return "证件上传"
            
        } else if type == YHMessageType.draft.rawValue {
            return "文书定稿"
            
        } else if type == YHMessageType.fileSign.rawValue {
            return "文件签字"
            
        } else if type == YHMessageType.infoSubmit.rawValue {
            return "资料递交"
            
        } else if type == YHMessageType.identityApproved.rawValue {
            return "身份获批"
            
        } else if type == YHMessageType.goToHK.rawValue {
            return "赴港办证"
            
        } else if type == YHMessageType.renewal.rawValue {
            return "身份续签"
            
        } else if type == YHMessageType.business.rawValue {
            return "银河商务"
            
        } else if type == YHMessageType.article.rawValue {
            return "银河资讯"
            
        } else if type == YHMessageType.txIM.rawValue {
            return title
            
        } else if type == YHMessageType.trip.rawValue {
            return "礼品兑换提醒"
                            
        }
        return ""
    }
}

class YHMsgListModel: SmartCodable {
    var information: YHMessageInfoModel = YHMessageInfoModel()
    var certificate: YHMessageInfoModel = YHMessageInfoModel()
    var draft: YHMessageInfoModel = YHMessageInfoModel()
    var signature: YHMessageInfoModel = YHMessageInfoModel()
    var dataSubmission: YHMessageInfoModel = YHMessageInfoModel()
    var approval: YHMessageInfoModel = YHMessageInfoModel()
    var goToHK: YHMessageInfoModel = YHMessageInfoModel()
    var renewal: YHMessageInfoModel = YHMessageInfoModel()
    var business: YHMessageInfoModel = YHMessageInfoModel()
    var article: YHMessageInfoModel = YHMessageInfoModel()
    var trip: YHMessageInfoModel = YHMessageInfoModel()
    
    required init() {
        self.information.type = YHMessageType.infoFill.rawValue
        self.certificate.type = YHMessageType.cerUpload.rawValue
        self.draft.type = YHMessageType.draft.rawValue
        self.signature.type = YHMessageType.fileSign.rawValue
        self.dataSubmission.type = YHMessageType.infoSubmit.rawValue
        self.approval.type = YHMessageType.identityApproved.rawValue
        self.goToHK.type = YHMessageType.goToHK.rawValue
        self.renewal.type = YHMessageType.renewal.rawValue
        self.business.type = YHMessageType.business.rawValue
        self.article.type = YHMessageType.article.rawValue
        self.trip.type = YHMessageType.trip.rawValue
    }
    
    enum CodingKeys: String, CodingKey {
        case information, certificate, draft, signature, approval, renewal, business, article, trip
        case dataSubmission = "data_submission"
        case goToHK = "go_to_hk"
    }
}

class YHDetailMessageModel: SmartCodable {
    
    var id: String = ""
    var title: String = ""
    var content: String = ""
    var time: Int = 0
    var isRead: Bool = false
    var orderId: String = ""
    var url: String = ""
    var redirectPage: String = ""
    
    required init() {
        
    }
    
    enum CodingKeys: String, CodingKey {
        case id, title, content, time, url
        case isRead = "is_read"
        case orderId = "order_id"
        case redirectPage = "redirect_page"
    }
}
