//
//  YHAIChatUIConfiguration.swift
//  galaxy
//
//  Created by Dufet on 2024/11/29.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAIChatConfiguration {
    
    var disableHandleMessage: Bool = false
    
    func registerMessageGroupCells(_ tableView: UITableView) {
        
        tableView.register(UITableViewCell.self, forCellReuseIdentifier: "UITableViewCell")
        tableView.register(YHAITextMessageCell.self, forCellReuseIdentifier: YHAITextMessageCell.cellReuseIdentifier)
        tableView.register(YHAIThinkingMessageCell.self, forCellReuseIdentifier: YHAIThinkingMessageCell.cellReuseIdentifier)
        tableView.register(YHProductListMessageCell.self, forCellReuseIdentifier: YHProductListMessageCell.cellReuseIdentifier)
        tableView.register(YHFixProductListMessageCell.self, forCellReuseIdentifier: YHFixProductListMessageCell.cellReuseIdentifier)
        tableView.register(YHCardMessageCell.self, forCellReuseIdentifier: YHCardMessageCell.cellReuseIdentifier)
        tableView.register(YHAIPictureMessageCell.self, forCellReuseIdentifier: YHAIPictureMessageCell.cellReuseIdentifier)
        tableView.register(YHRecommendTextMessageCell.self, forCellReuseIdentifier: YHRecommendTextMessageCell.cellReuseIdentifier)
    }
    
    func handleReceiveMessage(_ res: YHAIChatMessage?, _ done: Bool, _ messages: inout [YHAIChatMessage]) {
        
        // 去除loading消息
        removeThinkingMessageFromChatList(&messages)
        
        if disableHandleMessage {
            for msg in messages {
                msg.isDone = true
            }
            return
        }
        
        if let res = res {
            var find = false
            for msg in messages {
                if msg.messageId == res.messageId {
                    if msg.isNeedSpiceMessage(), res.isNeedSpiceMessage() {
                        // 多个文字需要拼接
                        find = true
                        if res.isTextCompleted() {
                            msg.isDone = true
                            
                        } else {
                            msg.body.contentText += res.body.contentText
                        }
                        
                        msg.updateBodyToData()
                    }
                }
            }
            if !find {
                messages.append(res)
            }
        }
        
        if done { // 思考完成
            for msg in messages {
                msg.isDone = true
            }
        }
    }
    
    func removeThinkingMessageFromChatList( _ messages: inout [YHAIChatMessage]) {
        var findIndex = -1
        for (index, msg) in messages.enumerated() {
            if msg.getType() == .thinking {
                findIndex = index
            }
        }
        if findIndex != -1 {
            messages.remove(at: findIndex)
        }
    }
    
    func createRobotResponseTextMessage(_ text: String) -> YHAIChatMessage {
        
        let message = YHAIChatMessage()
        message.messageId = UUID().uuidString + NSDate().timeIntervalSince1970.description
        message.isSelf = false
        let body = YHAIMessageBody()
        body.contentType = YHAIMessageType.text.rawValue
        body.contentText = text
        message.setDone()
        message.body = body
        message.updateBodyToData()
        return message
    }
    
    func createRobotResponseLocalPictureMessage(_ imgName: String, previewUrl: String) -> YHAIChatMessage {
        let message = YHAIChatMessage()
        message.messageId = UUID().uuidString + NSDate().timeIntervalSince1970.description
        message.isSelf = false
        let body = YHAIMessageBody()
        body.contentType = YHAIMessageType.picture.rawValue
        let imgInfo = YHAIImageInfo()
        imgInfo.imageType = YHAIImageType.local.rawValue
        imgInfo.localImageName = imgName
        imgInfo.imageUrl = previewUrl
        body.imageInfo = imgInfo
        message.setDone()
        message.body = body
        message.updateBodyToData()
        return message
    }

}
