//
//  YHCompanyAuthSettingCell.swift
//  galaxy
//
//  Created by alexzzw on 2025/10/11.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCompanyAuthSettingCell: UITableViewCell {
    
    // MARK: - Callback
    var onSwitchToggle: ((Bool) -> Void)?
    
    // MARK: - UI Components
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 16)
        label.textColor = UIColor.brandGrayColor8
        return label
    }()
    
    lazy var infoButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setImage(UIImage(named: "my_card_set_alert"), for: .normal)
        button.YH_clickEdgeInsets = UIEdgeInsets(top: 20, left: 20, bottom: 20, right: 20)
        return button
    }()
    
    private lazy var descriptionLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textColor = UIColor.brandGrayColor5
        label.numberOfLines = 0
        return label
    }()
    
    private lazy var toggleSwitch: UISwitch = {
        let switchView = UISwitch()
        switchView.onTintColor = UIColor.brandGrayColor8
        switchView.transform = CGAffineTransform(scaleX: 0.77, y: 0.77)
        switchView.addTarget(self, action: #selector(switchValueChanged(_:)), for: .valueChanged)
        return switchView
    }()
    
    // MARK: - Initialization
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    // MARK: - Setup UI
    private func setupUI() {
        selectionStyle = .none
        contentView.backgroundColor = .white
        backgroundColor = .white
        
        contentView.addSubview(titleLabel)
        contentView.addSubview(infoButton)
        contentView.addSubview(descriptionLabel)
        contentView.addSubview(toggleSwitch)
        
        toggleSwitch.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.centerY.equalToSuperview()
            make.width.equalTo(40)
            make.height.equalTo(22)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.top.equalTo(16)
            make.right.lessThanOrEqualTo(toggleSwitch.snp.left).offset(-12)
        }
        
        infoButton.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.centerY.equalTo(titleLabel)
            make.width.height.equalTo(18)
        }
        
        descriptionLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(toggleSwitch.snp.left).offset(-26)
            make.top.equalTo(titleLabel.snp.bottom).offset(8)
            make.bottom.equalTo(-16).priority(.high)
        }
    }
    
    // MARK: - Actions
    @objc private func switchValueChanged(_ sender: UISwitch) {
        onSwitchToggle?(sender.isOn)
    }
    
    // MARK: - Public Methods
    func configure(with model: YHSettingItem) {
        titleLabel.text = model.title
        descriptionLabel.text = model.subTitle
        toggleSwitch.isOn = model.isSelect
        infoButton.isHidden = !model.isShowAlert
    }
    
    // MARK: - Reuse
    override func prepareForReuse() {
        super.prepareForReuse()
        onSwitchToggle = nil
        infoButton.removeTarget(nil, action: nil, for: .allEvents)
        titleLabel.text = nil
        descriptionLabel.text = nil
        toggleSwitch.isOn = false
        infoButton.isHidden = true
    }
}
