//
//  YHNewProductCell.swift
//  galaxy
//
//  Created by Dufet on 2025/10/12.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHNewProductCell: UITableViewCell {

    static let cellReuseIdentifier = "YHNewProductCell"
    
    lazy var imgView: UIImageView = {
        let v = UIImageView()
        v.clipsToBounds = true
        return v
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

    func updateModel(_ model: YHSelectGoodsModel) {
        self.imgView.sd_setImage(with: URL(string: model.image), placeholderImage: UIImage(named: "global_default_image"))
    }
    
    func setupUI() {
        self.selectionStyle = .none
        self.contentView.addSubview(self.imgView)
        self.imgView.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(160)
            make.bottom.equalTo(-12)
        }
    }

}
