//
//  YHVisaRenewalPaymentStatus.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHVisaRenewalPaymentStatus: Int {
    // 待缴费 待获批 已缴费 已过期
    case pendingPayment = 7
    case paid = 8
    case expired = 9
    case pendingApproval = 10
    
    var title: String {
        switch self {
        case .pendingPayment:
            return "待缴费"
        case .pendingApproval:
            return "待获批"
        case .paid:
            return "已缴费"
        case .expired:
            return "已过期"
        }
    }
    
    var titleColor: UIColor? {
        switch self {
        case .pendingPayment:
            return .brandMainColor
        case .pendingApproval:
            return .yhOrangeColor
        case .paid:
            return .mainTextColor50
        case .expired:
            return .failColor
        }
    }
}
