//
//  YHVisaRenewalPayStatusCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalPayStatusCell: YHVisaRenewalPayInfoBaseCell {

    static let cellReuseIdentifier = "YHVisaRenewalPayStatusCell"
    
    private lazy var iconView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 15)
        label.textColor = .mainTextColor
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 13)
        label.textColor = .brandMainColor
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String, status: YHVisaRenewalPaymentStatus) {
        infoTitleLabel.text = title
        infoDetailLabel.text = status.title
        infoDetailLabel.textColor = status.titleColor
    }
}

extension YHVisaRenewalPayStatusCell {
    private func setupUI() {
        updateInnerCellCorner(.top)
        innerContainerView.addSubview(iconView)
        innerContainerView.addSubview(infoTitleLabel)
        innerContainerView.addSubview(infoDetailLabel)
        innerContainerView.addSubview(bottomLineView)
        iconView.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        bottomLineView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        iconView.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.width.equalTo(4)
            make.height.equalTo(15)
            make.centerY.equalTo(infoTitleLabel)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconView.snp.right).offset(12)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-12)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-16)
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(12)
            make.centerY.equalTo(infoTitleLabel)
        }
    }
}
