//
//  YHGCMySignatureDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/12/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCMySignatureDetailViewModel: YHBaseViewModel {
    var mainModel: YHMySignatureDetailModel?
    var pageUrl: String?
    var personalUrl: String?
    
    override init() {
        super.init()
    }
    
    func requestSignatureDetail(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["doc_id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.gcdetail
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureDetailModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.mainModel = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePageURL(_ id: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["doc_id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.gcpageUrl
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let data = json.data?.peel as? [String: String]
                self.pageUrl = data?["url"]
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalURL(callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        _ = YHNetRequest.postRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignaturePersonalWithNameAndPhoneURL(name: String, phone: String, callBackBlock: @escaping (_ success: Bool?, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["user_name": name,
                                      "mobile": phone]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.personalUrl
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.personalUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignCallBack(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.callBack
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignatureDownload(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.download
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let result = YHMySignatureURLModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self.pageUrl = result.url
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignConfirm(_ id: String, orderID: Int, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        var array: [[String: String]] = []
        let dataSource = mainModel?.signedDocument ?? []
        for item in dataSource {
            let param: [String: String] = ["name": item.name, "url": item.url]
            array.append(param)
        }
        let params: [String: Any] = ["id": orderID, "doc_id": id, "signed_docs": array]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.gcconfirm
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func sendEmailForDocs(_ params: [String: Any], callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.gcsendMail
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else {
                callBackBlock(false, nil)
                return
            }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func requestSignBack(_ id: String, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
//        let params: [String : Any] = ["order_id": orderId]
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.signCallBack
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
