//
//  UIDevice-Extension.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/11.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit
import DeviceKit

extension UIDevice {
    
    // MARK: - 屏幕size
    static let kScreenSize: CGRect = UIScreen.main.bounds
    
    // MARK: - 屏幕宽度
    static let kScreenW: CGFloat = UIScreen.main.bounds.width
    
    // MARK: - 屏幕高度
    static let kScreenH: CGFloat = UIScreen.main.bounds.height
    
    // MARK: - iOS系统版本号
    static let kSystemVersion: String = UIDevice.current.systemVersion
    
    // MARK: - 顶部安全区高度
    static func bs_safeDistanceTop() -> CGFloat {
        if #available(iOS 13.0, *) {
            let scene = UIApplication.shared.connectedScenes.first
            guard let windowScene = scene as? UIWindowScene else { return 0 }
            guard let window = windowScene.windows.first else { return 0 }
            return window.safeAreaInsets.top
        }
        //        else if #available(iOS 11.0, *) {
        //            guard let window = UIApplication.shared.windows.first else { return 0 }
        //            return window.safeAreaInsets.top
        //        }
        return 0
    }
    
    // MARK: - 底部安全区高度
    static func bs_safeDistanceBottom() -> CGFloat {
        if #available(iOS 13.0, *) {
            let scene = UIApplication.shared.connectedScenes.first
            guard let windowScene = scene as? UIWindowScene else { return 0 }
            guard let window = windowScene.windows.first else { return 0 }
            return window.safeAreaInsets.bottom
        }
        //        else if #available(iOS 11.0, *) {
        //            guard let window = UIApplication.shared.windows.first else { return 0 }
        //            return window.safeAreaInsets.bottom
        //        }
        return 0
    }
    
    // MARK: - 顶部状态栏高度（包括安全区）
    static func bs_statusBarHeight() -> CGFloat {
        var statusBarHeight: CGFloat = 0
        if #available(iOS 13.0, *) {
            let scene = UIApplication.shared.connectedScenes.first
            guard let windowScene = scene as? UIWindowScene else { return 0 }
            guard let statusBarManager = windowScene.statusBarManager else { return 0 }
            statusBarHeight = statusBarManager.statusBarFrame.height
        }
        //        else {
        //            statusBarHeight = UIApplication.shared.statusBarFrame.height
        //        }
        return statusBarHeight
    }
    
    // MARK: - 导航栏高度
    static func bs_navigationBarHeight() -> CGFloat {
        return 44.0
    }
    
    // MARK: - 状态栏+导航栏的高度
    static func bs_navigationFullHeight() -> CGFloat {
        return UIDevice.bs_statusBarHeight() + UIDevice.bs_navigationBarHeight()
    }
    
    // MARK: - 底部导航栏高度
    static func bs_tabBarHeight() -> CGFloat {
        return 49.0
    }
    
    // MARK: - 底部导航栏高度（包括安全区）
    static func bs_tabBarFullHeight() -> CGFloat {
        return UIDevice.bs_tabBarHeight() + UIDevice.bs_safeDistanceBottom()
    }
    
    // MARK: - 版本号
    static func appVersion() -> String {
        let infoDictionary = Bundle.main.infoDictionary
        if let infoDictionary = infoDictionary {
            if let appVersion = infoDictionary["CFBundleShortVersionString"] as? String {
                return appVersion
            }
            
        }
        return " "
    }
    
    // MARK: - 内部编译版本号
    static func appBuild() -> String {
        let infoDictionary = Bundle.main.infoDictionary
        if let infoDictionary = infoDictionary {
            if let appBuild = infoDictionary["CFBundleVersion"] as? String {
                return appBuild
            }
        }
        return " "
    }
    
    // MARK: - 机器名称
    static func iPhoneModelName() -> String {
        let device = Device.current
        var name = "未知"
        if device == .iPhone4 {
            name = "iPhone4"
        } else if device == .iPhone5 {
            name = "iPhone5"
        } else if device == .iPhone6 {
            name = "iPhone6"
        } else if device == .iPhone7 {
            name = "iPhone7"
        } else if device == .iPhone8 {
            name = "iPhone8"
        } else if device == .iPhone11 {
            name = "iPhone11"
        } else if device == .iPhone12 {
            name = "iPhone12"
        } else if device == .iPhone13 {
            name = "iPhone13"
        } else if device == .iPhone14 {
            name = "iPhone14"
        } else if device == .iPhone15 {
            name = "iPhone15"
        } else if device == .iPhone4s {
            name = "iPhone4s"
        } else if device == .iPhone5c {
            name = "iPhone5c"
        } else if device == .iPhone5s {
            name = "iPhone5s"
        } else if device == .iPhone6s {
            name = "iPhone6s"
        } else if device == .iPhoneX {
            name = "iPhoneX"
        } else if device == .iPhoneSE {
            name = "iPhoneSE"
        } else if device == .iPhoneXR {
            name = "iPhoneXR"
        } else if device == .iPhoneXS {
            name = "iPhoneXS"
        } else if device == .iPhoneSE2 {
            name = "iPhoneSE2"
        } else if device == .iPhoneSE3 {
            name = "iPhoneSE3"
        } else if device == .iPhone11Pro {
            name = "iPhone11Pro"
        } else if device == .iPhone12Pro {
            name = "iPhone12Pro"
        } else if device == .iPhone13Pro {
            name = "iPhone13Pro"
        } else if device == .iPhone14Pro {
            name = "iPhone14Pro"
        } else if device == .iPhone15Pro {
            name = "iPhone15Pro"
        } else if device == .iPhone6Plus {
            name = "iPhone6Plus"
        } else if device == .iPhone7Plus {
            name = "iPhone7Plus"
        } else if device == .iPhone8Plus {
            name = "iPhone8Plus"
        } else if device == .iPhone12Mini {
            name = "iPhone12Mini"
        } else if device == .iPhone13Mini {
            name = "iPhone13Mini"
        } else if device == .iPhone14Plus {
            name = "iPhone14Plus"
        } else if device == .iPhone15Plus {
            name = "iPhone15Plus"
        } else if device == .iPhone6sPlus {
            name = "iPhone6sPlus"
        } else if device == .iPhoneXSMax {
            name = "iPhoneXSMax"
        } else if device == .iPhone11ProMax {
            name = "iPhone11ProMax"
        } else if device == .iPhone12ProMax {
            name = "iPhone12ProMax"
        } else if device == .iPhone13ProMax {
            name = "iPhone13ProMax"
        } else if device == .iPhone14ProMax {
            name = "iPhone14ProMax"
        } else if device == .iPhone15ProMax {
            name = "iPhone15ProMax"
        } else {
            name = "非iPhone机型"
        }
        return name
    }
    
    static func iPhoneVersion() -> String {
        return "iOS" + (Device.current.systemVersion ?? "")
    }
    
    // 判断 网络 是否设置了代理
    public class func isUsedProxy() -> Bool {
        guard let proxy = CFNetworkCopySystemProxySettings()?.takeUnretainedValue() else {
            return false
        }
        guard let dict = proxy as? [String: Any] else {
            return false
        }
        _ = dict.isEmpty // 有时候未设置代理dictionary也不为空，而是一个空字典
        guard let HTTPProxy = dict["HTTPProxy"] as? String else {
            return false
        }
        if HTTPProxy.count > 0 {
            return true
        }
        return false
    }
    
    // 判断手机是否越狱
    public class func isJailbroken() -> Bool {
        let fileManager = FileManager.default
        let pathsToCheck = [
            "/Applications/Cydia.app",
            "/private/var/lib/apt/",
            "/private/var/lib/cydia/",
            "/private/var/stash/",
            "/private/var/tmp/cydia.log",
            "/private/var/mobile/Library/Cydia/",
            "/private/var/mobile/Library/MobileSubstrate/DynamicLibraries/",
            "/private/var/mobile/bin/bash",
            "/private/var/mobile/bin/sh",
            "/private/var/mobile/bin/zsh",
            "/private/var/mobile/usr/sbin/sshd",
            "/private/var/mobile/usr/bin/sshd",
            "/private/var/mobile/Media/Cydia",
            "/private/var/root/Documents/Cydia",
            "/private/var/tmp/cydia.log",
            "/private/var/lib/dpkg/"
        ]
        
        for path in pathsToCheck {
            if fileManager.fileExists(atPath: path) {
                return true
            }
        }
        return false
    }
}
