//
//  YHGCSignatureAddViewController.swift
//  galaxy
//
//  Created by EDY on 2024/12/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCSignatureAddViewController: YHBaseViewController {
    var bottomView: YHBottomNextView!
    var tableView: UITableView!
    var viewModel: YHGCSignatureAddViewModel!
    var baseDataSource: [YHSectionWorkExperienceModel]?
    var workID: Int = 0
    var orderID: Int = 0
    var isMore: Bool = false
    var isShowPrompt: Bool = false
    var isShowMessageSelect: Bool = true
    var isKeyboardShow: Bool = false
    var selectReasonIndex: Int = 5
    
    override func viewDidLoad() {
        super.viewDidLoad()
        viewModel = YHGCSignatureAddViewModel()
        gk_navTitle = "信息补充"
        gk_navBackgroundColor = .white
        gk_navBarAlpha = 1.0
        
        setView()
        getData()
    }
    
    func getData() {
        viewModel.requestDetail(orderID) {[weak self] success, _ in
            guard let self = self else { return }
            if success ?? false {
                updateDataSource()
            } else {
                self.viewModel.position.order_id = orderID
                updateDataSource()
            }
        }
    }
    
    func updateDataSource() {
        bottomView.nextButton.setTitle("提交", for: .normal)
        self.baseDataSource = self.viewModel.getBaseDataSource(false)
        self.tableView.reloadData()
    }
    
    func setView() {
        tableView = {
            let tableView = UITableView(frame: .zero, style: .grouped)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.sectionHeaderHeight = 16
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHGCSignatureAddTableViewCell.self)
            tableView.register(cellWithClass: YHGCDocumentPromptTableViewCell.self)
            return tableView
        }()
        view.addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom() - 64)
            make.left.right.bottom.equalTo(view)
        }
        
        bottomView = {
            let bottom = YHBottomNextView()
            bottom.saveButton.isHidden = true
            bottom.nextButton.snp.makeConstraints { make in
                make.right.equalTo(-16)
                make.top.equalTo(10)
                make.height.equalTo(44)
                make.left.equalTo(16)
            }
            bottom.nextblock = { [weak self] in
                bottom.nextButton.isEnabled = false
                guard let self = self else { return }
                if self.viewModel.isCanNext() {
                    self.viewModel.saveGcSaveinfo(callBackBlock: {[weak self] _, error in
                        guard let self = self else { return }
                        bottom.nextButton.isEnabled = true
                        if let error = error {
                            YHHUD.flash(message: error.errorMsg )
                        } else {
                            YHHUD.hideFlashMessage()
                            YHHUD.flash(message: "提交成功")
                            self.navigationController?.popViewController()
                        }
                    })
                } else {
                    bottom.nextButton.isEnabled = true
                    self.isShowPrompt = true
                    self.updateDataSource()
                    YHHUD.flash(message: "您还有信息未填写")
                }
            }
            return bottom
        }()
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalTo(view)
            make.height.equalTo(k_Height_safeAreaInsetsBottom() + 64)
        }
        bottomView.layoutIfNeeded()
        bottomView.nextButton.addYinHeGradualLayer()
    }
    
}

extension YHGCSignatureAddViewController: UITableViewDelegate, UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 2
    }

    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if indexPath.section == 1 {
            let cell = tableView.dequeueReusableCell(withClass: YHGCSignatureAddTableViewCell.self)
            cell.dataSource = baseDataSource?[indexPath.row]
            cell.workExperienceBlock = {[weak self] model in
                guard let self = self else { return }
                self.viewModel.updateModel(model)
                let id = model.id
                if id != .id1 && id != .id2 && id != .id3 && id != .id4 && id != .id5 {
                    self.updateDataSource()
                }
            }
            return cell
        } else {
            let cell = tableView.dequeueReusableCell(withClass: YHGCDocumentPromptTableViewCell.self)
            cell.backgroundColor = .clear
            cell.contentView.backgroundColor = .clear
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        if indexPath.section == 1 {
            let array = baseDataSource?[indexPath.row].models ?? []
            var h = 0
            for i in 0..<array.count {
                let data = array[i]
                let message = data.message ?? ""
                let isShow = data.isShowPrompts ?? false
                if data.id == .id6 {
                    h += 72
                } else {
                    h += 52
                }
                if isShow && message.count == 0 {
                    h += 20
                }
            }
            return CGFloat(h + 14)
        } else {
            return 104
        }
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 7))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 16
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.01
    }
}
