//
//  YHMakePlanStateHeadView.swift
//  galaxy
//
//  Created by EDY on 2025/3/27.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMakePlanStateHeadView: UIView {
    var dataSource: YHMakePlanScoreModel? {
        didSet {
            guard let dataSource = dataSource else { return }
            configure(model: dataSource)
        }
    }
    
    // MARK: - UI Components
    private let yearsLabel: UILabel = {
        let label = UILabel()
        label.text = "5"
        label.font = UIFont(name: "D-DIN-PRO-Bold", size: 32)
        label.textColor = .mainTextColor
        label.textAlignment = .center
        return label
    }()
    
    private let yearsDescriptionLabel: UILabel = {
        let label = UILabel()
        label.text = "预计可续期(年)"
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = UIColor(hex: 0x8893a2)
        label.textAlignment = .center
        return label
    }()
    
    private let percentageLabel: UILabel = {
        let label = UILabel()
        label.text = "90%"
        label.font = UIFont(name: "D-DIN-PRO-Bold", size: 32)
        label.textColor = .mainTextColor
        label.textAlignment = .center
        return label
    }()
    
    private let progressDescriptionLabel: UILabel = {
        let label = UILabel()
        label.text = "预测续签通过率"
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = UIColor(hex: 0x8893a2)
        label.textAlignment = .center
        return label
    }()
    
    private let explainLabel: UILabel = {
        let label = UILabel()
        label.text = "*该概率为预估概率，最终以实际续签结果为准"
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = UIColor(hex: 0x8893a2)
        label.textAlignment = .center
        label.backgroundColor = UIColor(hex: 0xf8f9fb)
        label.layer.cornerRadius = kCornerRadius4
        return label
    }()
    
    // MARK: - Initialization
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupView()
        setupConstraints()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
        setupView()
        setupConstraints()
    }
    
    // MARK: - Setup
    private func setupView() {
        addSubview(yearsLabel)
        addSubview(yearsDescriptionLabel)
        addSubview(percentageLabel)
        addSubview(progressDescriptionLabel)
        addSubview(explainLabel)
    }
    
    private func setupConstraints() {
        yearsLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.left.equalToSuperview().offset(16)
            make.right.equalTo(self.snp.centerX)
        }
        
        yearsDescriptionLabel.snp.makeConstraints { make in
            make.top.equalTo(yearsLabel.snp.bottom).offset(4)
            make.left.equalToSuperview().offset(16)
            make.right.equalTo(self.snp.centerX)
        }
        
        percentageLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-16)
            make.left.equalTo(self.snp.centerX)
        }
        
        progressDescriptionLabel.snp.makeConstraints { make in
            make.top.equalTo(percentageLabel.snp.bottom).offset(4)
            make.right.equalToSuperview().offset(-16)
            make.left.equalTo(self.snp.centerX)
        }
        
        explainLabel.snp.makeConstraints { make in
            make.bottom.equalTo(-16)
            make.right.equalToSuperview().offset(-18)
            make.left.equalToSuperview().offset(18)
            make.height.equalTo(29)
        }
    }
    
    // MARK: - Configuration
    func configure(model: YHMakePlanScoreModel) {
        yearsLabel.text = "\(model.year)"
        percentageLabel.text = model.pass_rate
    }
}
