//
//  YHConnectListViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/9/25.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import JXSegmentedView
import UIKit

class YHConnectListViewController: YHBaseViewController {
    let viewModel = YHMatchUserViewModel()
    var arr: [String] = ["", "", ""]

    lazy var tableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .grouped)
        tableView.showsVerticalScrollIndicator = false
        tableView.separatorStyle = .none
        tableView.delegate = self
        tableView.dataSource = self
        tableView.register(YHConnectListCell.self, forCellReuseIdentifier: YHConnectListCell.cellReuseIdentifier)
        return tableView
    }()

    lazy var emptyDataTipsView: YHMyFriendsNoDataView = {
        let view = YHMyFriendsNoDataView(frame: CGRect(x: 0, y: k_Height_NavigationtBarAndStatuBar, width: KScreenWidth, height: KScreenHeight - k_Height_NavigationtBarAndStatuBar))
        view.bottomBtnClick = {
            [weak self] in
            guard let self = self else { return }
            self.navigationController?.popViewController(animated: true)
        }
        view.isHidden = true
        return view
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navigationBar.isHidden = true
        view.backgroundColor = UIColor.white
        view.addSubview(tableView)
        view.addSubview(emptyDataTipsView)
        tableView.snp.makeConstraints { make in
            make.left.equalTo(0)
            make.right.equalTo(0)
            make.bottom.equalToSuperview()
            make.top.equalToSuperview().offset(0)
        }
    }
}

extension YHConnectListViewController: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return arr.count
    }

    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        guard let cell = tableView.dequeueReusableCell(withIdentifier: YHConnectListCell.cellReuseIdentifier, for: indexPath) as? YHConnectListCell else { return UITableViewCell() }
        return cell
    }

    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }

    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        if 0 <= indexPath.row && indexPath.row < arr.count {
            let vc = YHNameCardContainerViewController()
            navigationController?.pushViewController(vc)
        }
    }
}

extension YHConnectListViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}
