//
//  YHVisaRenewalTroubleshootingGuideHeaderCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/10.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalTroubleshootingGuideHeaderCell: UITableViewCell {
    static let cellReuseIdentifier = "YHVisaRenewalTroubleshootingGuideHeaderCell"

    private lazy var infoTitleIcon: UIImageView = {
        let view = UIImageView()
        view.contentMode = .scaleAspectFit
        view.image = UIImage(named: "resign_visa_guide_error_title")
        return view
    }()
    
    private lazy var paragraphDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor70
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineHeightMultiple = 1.07
        let attributedText = NSAttributedString(
            string: "如缴费页面最终出现“不符合使用網上付款服務的资格”字样，请亲自前往将军澳入境处人工处理，以下是办理指引：",
            attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle]
        )
        label.attributedText = attributedText
        return label
    }()
    
    private lazy var errorIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "resign_visa_guide_error_content")
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }

}

extension YHVisaRenewalTroubleshootingGuideHeaderCell {
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .clear
        contentView.addSubview(infoTitleIcon)
        contentView.addSubview(paragraphDetailLabel)
        contentView.addSubview(errorIcon)
        
        infoTitleIcon.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(5)
            make.left.equalToSuperview().offset(22)
            make.height.equalTo(25)
            make.width.equalTo(202)
        }
        
        paragraphDetailLabel.snp.makeConstraints { make in
            make.top.equalTo(infoTitleIcon.snp.bottom).offset(34)
            make.left.equalToSuperview().offset(20)
            make.right.lessThanOrEqualToSuperview().offset(-20)
        }
        let whR = 335.0 / 300.0
        errorIcon.snp.makeConstraints { make in
            make.top.equalTo(paragraphDetailLabel.snp.bottom).offset(12)
            make.left.equalTo(paragraphDetailLabel)
            make.right.equalToSuperview().offset(-20)
            make.width.equalTo(errorIcon.snp.height).multipliedBy(whR)
            make.bottom.equalToSuperview()
        }
    }
}
