//
//  YHRangeDatePickerSheetView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHRangeDatePickerSheetView2: UIView {
    static let contentViewH2: CGFloat = 40 + 13 + 80 + 12 + YHRangeDatePickerView2.viewH2 + 58 + 98// (16 + 24) + (12 + 1) + (12 + 68) + 12 + YHRangeDatePickerView2.viewH2 + 52 + 6 + 98
    
    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor(hex: 0x0F1214, alpha: 0.5)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()
    
    lazy var titleLable: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.text = "选择预约在港递交时间"
        label.textAlignment = .center
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var bottomView: UIView = {
        let view = UIView()
        view.backgroundColor = .clear
        view.addSubview(self.rewardBtn)
        self.rewardBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(10)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(44)
        }
        view.layer.zPosition = 10
        return view
    }()
    
    // 知道了
    lazy var rewardBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("确定", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickSureBtn), for: .touchUpInside)
        button.backgroundColor = UIColor.brandMainColor
        return button
    }()
    
    lazy var closeBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
        
        button.setImage(UIImage(named: "work_example_close"), for: .normal)
        button.setImage(UIImage(named: "work_example_close"), for: .selected)
        return button
    }()
    
    lazy var datePickView: YHRangeDatePickerView2 = {
        let view = YHRangeDatePickerView2()
        return view
    }()
    
    lazy var warnImageV: UIImageView = {
        let imageV  = UIImageView()
        imageV.image = UIImage(named: "appoint_warm_date_picker2")
        imageV.contentMode = .scaleToFill
        imageV.clipsToBounds = true
        return imageV
    }()
    
    lazy var timeHoldView: YHPickTimeHoldView = {
        let view  = YHPickTimeHoldView()
        return view
    }()
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    private var selectedDate: Date?
    private var selectedTime: String?
    
    typealias Block = (String, String) -> Void
    var block: Block?
    
    var minDateStr: String = "2024-10-01" {
        didSet {
            let dateFormatter = DateFormatter()
            dateFormatter.dateFormat = "yyyy-MM-dd"
            
            if minDateStr.count == "2024-11-10".count {
                let miniDate = dateFormatter.date(from: minDateStr)
                
                datePickView.minDate = miniDate
            }
            
        }
    }
    var maxDateStr: String = "2025-10-01" {
        didSet {
            let dateFormatter = DateFormatter()
            dateFormatter.dateFormat = "yyyy-MM-dd"
            
            if maxDateStr.count == "2024-11-10".count {
                let maxDate = dateFormatter.date(from: maxDateStr)
                datePickView.maxDate = maxDate
            }
        }
    }
    
    var defaultTime: String = "" {
        didSet {
            selectedTime = defaultTime
            timeHoldView.timeTextField.text = selectedTime
        }
    }
    
    var viewTitle: String = "" {
        didSet {
            titleLable.text = viewTitle
        }
    }
    
    var showBestFlag: Bool = true {
        didSet {
            datePickView.showBestDateFlag = showBestFlag
        }
    }
}

extension YHRangeDatePickerSheetView2 {
    
    static func sheetView() -> YHRangeDatePickerSheetView2 {
        let view = YHRangeDatePickerSheetView2(frame: UIScreen.main.bounds)
        return view
    }
    
    func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
        
        UIView.animate(withDuration: 0.5) {
            let whiteHeight = YHRangeDatePickerSheetView2.contentViewH2
            self.whiteContentView.frame = CGRect(x: 0, y: KScreenHeight - whiteHeight, width: KScreenWidth, height: whiteHeight)
        }
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func clickSureBtn() {
        if isChooseOk() {
            if let date1 = selectedDate, let time = selectedTime {
                let dateFormatter = DateFormatter()
                dateFormatter.dateFormat = "yyyy-MM-dd"
                let dateString = dateFormatter.string(from: date1)
                self.block?(dateString, time)
            }
            dismiss()
        } else {
            var msg = ""
            if selectedDate == nil {
                msg = "请选择日期"
            } else {
                msg = "请选择具体时间"
            }
            YHHUD.flash(message: msg)
        }
    }
    
    func isChooseOk() -> Bool {
        if selectedDate != nil, selectedTime != nil {
            return true
        }
        return false
    }
    
//    func checkSubmitButtonStatus() {
//        if isChooseOk() {
//            setSubmitButtonDisable(false)
//        } else {
//            setSubmitButtonDisable(true)
//        }
//    }
}

private extension YHRangeDatePickerSheetView2 {
    func setSubmitButtonDisable(_ disableFlag: Bool) {
        
        /*
         lazy var rewardBtn: UIButton = {
             let button = UIButton(type: .custom)
             button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
             button.contentHorizontalAlignment = .center
             button.setTitle("确定", for: .normal)
             button.setTitleColor(UIColor.white, for: .normal)
             button.layer.cornerRadius = kCornerRadius3
             button.clipsToBounds = true
             button.addTarget(self, action: #selector(clickSureBtn), for: .touchUpInside)
             button.backgroundColor = UIColor.brandMainColor
             return button
         }()
         */
        rewardBtn.isEnabled = true
        rewardBtn.backgroundColor = UIColor.brandMainColor
        
//        if disableFlag {
//            //不可点击
//            rewardBtn.backgroundColor = UIColor.brandMainColor30
//        } else {
//            //可点击
//            rewardBtn.backgroundColor = UIColor.brandMainColor
//        }
    }
    
    func setupUI() {
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)

        let corner = UIRectCorner(rawValue: UIRectCorner.topLeft.rawValue | UIRectCorner.topRight.rawValue)
        let path = UIBezierPath(roundedRect: bounds, byRoundingCorners: corner, cornerRadii: CGSize(width: kCornerRadius6, height: kCornerRadius6))
        let layer = CAShapeLayer()
        layer.frame = whiteContentView.bounds
        layer.path = path.cgPath
        whiteContentView.layer.mask = layer
        whiteContentView.clipsToBounds = true
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        let whiteHeight = YHRangeDatePickerSheetView2.contentViewH2
        whiteContentView.frame = CGRect(x: 0, y: KScreenHeight, width: KScreenWidth, height: whiteHeight)
        
        whiteContentView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.bottom.left.right.equalToSuperview()
            make.height.equalTo(98)
        }
        
        whiteContentView.addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(kMargin)
            make.left.right.equalToSuperview()
            make.height.equalTo(24)
        }
        
        whiteContentView.addSubview(closeBtn)
        closeBtn.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-21)
            make.height.width.equalTo(24)
            make.centerY.equalTo(titleLable.snp.centerY)
        }
        
        whiteContentView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLable.snp.bottom).offset(12)
            make.left.equalToSuperview().offset(21)
            make.right.equalToSuperview().offset(-21)
            make.height.equalTo(1)
        }
        
        whiteContentView.addSubview(warnImageV)
        warnImageV.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(12)
            make.centerX.equalToSuperview()
            make.width.equalTo(343)
            make.height.equalTo(68)
        }
        
        whiteContentView.addSubview(datePickView)
        datePickView.snp.makeConstraints { make in
            make.top.equalTo(warnImageV.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.height.equalTo(YHRangeDatePickerView2.viewH2)
        }
        
        let dateFormatter = DateFormatter()
        dateFormatter.dateFormat = "yyyy-MM-dd HH:mm"
        
        if minDateStr.count == "2024-11-10 14:20".count, maxDateStr.count == "2024-11-10 14:20".count {
            let miniDate = dateFormatter.date(from: minDateStr)
            let maxDate = dateFormatter.date(from: maxDateStr)
            
            datePickView.minDate = miniDate
            datePickView.maxDate = maxDate
        }
        
        datePickView.showBestDateFlag = showBestFlag
        
        whiteContentView.addSubview(timeHoldView)
        timeHoldView.snp.makeConstraints { make in
            make.top.equalTo(datePickView.snp.bottom)
            make.left.right.equalToSuperview()
            make.height.equalTo(52)
        }
        setSubmitButtonDisable(true)
        
        let tap: UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        timeHoldView.isUserInteractionEnabled = true
        timeHoldView.addGestureRecognizer(tap)
        
        datePickView.block = { [weak self] date in
            self?.selectedDate = date
//            self?.checkSubmitButtonStatus()
            
//            if self?.selectedTime == nil {
//                YHHUD.flash(message: "选择具体时间")
//            }
            
//            self?.clickSureBtn()
        }
    }
    
    @objc func tapButton(gestureRecognizer: UITapGestureRecognizer) {
        YHDatePickView.show(type: .timeForAppointHK, title: "选择具体时间", lastIsTaday: false, currentDay: defaultTime) { date in
            self.selectedTime = date
            self.defaultTime = date
            self.timeHoldView.timeTextField.text = date
//            self.checkSubmitButtonStatus()
        } dismiss: {
        }
    }
}
