//
//  YHAIListModel.swift
//  galaxy
//
//  Created by Dufet on 2024/11/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHAIListModel: SmartCodable {
    
    var mainBotId: String = ""
    var entranceConfig: [YHEntranceconfigModel] = []
    
    required init() {
        
    }
}

enum YHAIRobotType: String {
    case main = "mainBot"
    case education = "educationBot"
    case sale = "saleBot"
    case image = "entryPrecautionsImage"
    case business = "businessBot"
    
}

class YHEntranceconfigModel: SmartCodable {
    
    var id: Int = 0
    var title: String = ""
    var icon: String = ""
    var cover: String = ""
    var description: String = ""
    var btnText: String = ""
    var redirectMode: Int = 0
    var businessType: String = ""
    var redirectPath: String = ""
    
    var titleName: String {
        if businessType == "businessBot" {
            return "银河商务规划师"
        } else {
            return ""
        }
    }
    
    func isNeedShowBannerHeader() -> Bool {
        if  businessType == YHAIRobotType.education.rawValue || businessType == YHAIRobotType.sale.rawValue || businessType == YHAIRobotType.business.rawValue {
            return true
        }
        return false
    }
    
    required init() {
        
    }
}

class YHAIBoardInfo: SmartCodable {
    
    var prologue: String = ""
    var suggestedQuestions: [String] = []
    
    required init() {
        
    }
}

class YHAIBotConfigInfo: SmartCodable {
    
    var description: String = ""
    var onboardingInfo: YHAIBoardInfo = YHAIBoardInfo()
    
    required init() {
        
    }
}
