//
//  BsHUDContainerView.swift
//  PKHUD Demo
//
//  Created by ahao on 2018/3/20.
//  Copyright © 2018年 NSExceptional. All rights reserved.
//

import UIKit

class YHHUDContainerView: UIView {
    
    static let defaultFrame = CGRect(origin: CGPoint.zero, size: CGSize(width: 156.0, height: 156.0))
    
    private let offSet: CGFloat
    
    var contentView: UIView
    init(contentView: UIView, offSet: CGFloat = 0) {
        self.contentView = contentView
        self.offSet = offSet
        super.init(frame: YHHUDContainerView.adjustFrame(contentViewFrame: contentView.frame, offSet: offSet))
        addSubview(contentView)
    }
    
    func adjustFrame() -> CGRect {
        return YHHUDContainerView.adjustFrame(contentViewFrame: contentView.frame, offSet: offSet)
    }
    
    class func adjustFrame(contentViewFrame: CGRect, offSet: CGFloat) -> CGRect {
        let height = contentViewFrame.height + abs(offSet) * 2
        let adjustSize = CGSize(width: contentViewFrame.width, height: height)
        return CGRect(origin: CGPoint.zero, size: adjustSize)
    }
    
    override func layoutSubviews() {
        super.layoutSubviews()
        let contentSize = contentView.frame.size
        contentView.frame = CGRect(origin: CGPoint.zero, size: contentSize)
        contentView.center = CGPoint(x: bounds.width/2.0, y: bounds.height/2.0 + offSet)
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}
