//
//  YHMakePlanViewModel.swift
//  galaxy
//
//  Created by EDY on 2025/4/1.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMakePlanViewModel: YHBaseViewModel {
    var makePlanModel: YHMakePlanModel = YHMakePlanModel()
    var score: YHMakePlanScoreModel = YHMakePlanScoreModel()
    // 请求产品列表
    func getProductList(callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignPlan.productListApi
        _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHMakePlanModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self?.makePlanModel = result
                self?.makePlanModel.updateAddCartStatus()
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    // 请求产品列表
    func getRate(model: YHMakePlanModel, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        var basic: [Int] = []
        var work: [Int] = []
        var live: [Int] = []
        var invest: [Int] = []
        let basicArray = makePlanModel.basic
        let workArray = makePlanModel.work
        let liveArray = makePlanModel.live
        let investArray = makePlanModel.invest
        
        for item in basicArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            basic.append(subItem.product_id)
                        }
                    }
                } else {
                    basic.append(item.product_id)
                }
            }
        }
        
        for item in workArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            work.append(subItem.product_id)
                        }
                    }
                } else {
                    work.append(item.product_id)
                }
            }
        }
        
        for item in liveArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            live.append(subItem.product_id)
                        }
                    }
                } else {
                    live.append(item.product_id)
                }
            }
        }
        
        for item in investArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            invest.append(subItem.product_id)
                        }
                    }
                } else {
                    invest.append(item.product_id)
                }
            }
        }
        var params: [String: Any] = ["work_product_ids": work,
                                     "live_product_ids": live,
                                     "invest_product_ids": invest,
                                     "basic_product_ids": basic]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignPlan.getRate
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                guard let dic = json.data?.peel as?  [String: Any], let result = YHMakePlanScoreModel.deserialize(from: dic) else {
                    callBackBlock(false, nil)
                    return
                }
                self?.score = result
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func addShopCard(model: YHMakePlanModel, callBackBlock: @escaping (_ success: Bool, _ error: YHErrorModel?) -> Void) {
        var basic: [Int] = []
        let basicArray = makePlanModel.basic
        let workArray = makePlanModel.work
        let liveArray = makePlanModel.live
        let investArray = makePlanModel.invest
        
        for item in basicArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            basic.append(subItem.product_id)
                        }
                    }
                } else {
                    basic.append(item.product_id)
                }
            }
        }
        
        for item in workArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            basic.append(subItem.product_id)
                        }
                    }
                } else {
                    basic.append(item.product_id)
                }
            }
        }
        
        for item in liveArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            basic.append(subItem.product_id)
                        }
                    }
                } else {
                    basic.append(item.product_id)
                }
            }
        }
        
        for item in investArray {
            if item.is_add_cart == true {
                if item.sub_product.count > 0 {
                    for subItem in item.sub_product {
                        if subItem.is_add_cart == true {
                            basic.append(subItem.product_id)
                        }
                    }
                } else {
                    basic.append(item.product_id)
                }
            }
        }
        let params: [String: Any] = ["ids": basic,
                                     "create_source": 2]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignPlan.store
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard self != nil else { return }
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let error: YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.count > 0 ? json.msg : "数据错误")
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
