//
//  YHActivityTravelCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/6/21.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivityTravelCell: UITableViewCell {
    static let cellReuseIdentifier = "YHActivityTravelCell"
    
    private var isApplyFlag: Bool = true
    
    var dataModel: YHActivityTravelModel? {
        didSet {
            updateUI()
        }
    }
    
    typealias Block = () -> Void
    var block: Block?
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    lazy var statusLable: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 28)
        lable.text = "已报名"
        return lable
    }()
    
    // 活动名称地址
    lazy var acitivityTitle: YHActivityTravelitemView = {
        let view = YHActivityTravelitemView()
        return view
    }()
    
    // 报名人数
    lazy var acitivityApplyInfo: YHActivityApplyInfoItemView = {
        let view = YHActivityApplyInfoItemView()
        return view
    }()
    
    // 活动温馨提示
    lazy var acitivityTips: YHActivityTipsItemView = {
        let view = YHActivityTipsItemView()
        view.showLineFlag = false
        return view
    }()
    
    // 取消活动
    lazy var cancelButton: UIButton = {
        let button = UIButton(type: .custom)
        button.backgroundColor =  UIColor.brandMainColor
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("取消报名", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.addTarget(self, action: #selector(clickCancelBtn), for: .touchUpInside)
        
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        return button
    }()
}

extension YHActivityTravelCell {
    func updateUI() {
        guard let model = dataModel else {
            return
        }
        
        if model.status.int == 2 {
            cancelButton.isHidden = false
            cancelButton.setTitle("取消报名", for: .normal)
            cancelButton.setTitle("取消报名", for: .highlighted)
            
            cancelButton.setTitleColor(UIColor.mainTextColor, for: .normal)
            cancelButton.setTitleColor(UIColor.mainTextColor, for: .highlighted)
            
            cancelButton.backgroundColor = .clear
            cancelButton.layer.borderWidth = 1
            cancelButton.layer.borderColor = UIColor.mainTextColor50.cgColor
            
            statusLable.text = "已报名"
        } else if model.status.int == 4 || model.status.int == 1 {
            cancelButton.isHidden = false
            
            cancelButton.setTitle("重新报名", for: .normal)
            cancelButton.setTitle("重新报名", for: .highlighted)
            
            cancelButton.setTitleColor(UIColor.white, for: .normal)
            cancelButton.setTitleColor(UIColor.white, for: .highlighted)
            
            cancelButton.backgroundColor = .brandMainColor
            cancelButton.layer.borderWidth = 0
            cancelButton.layer.borderColor = UIColor.clear.cgColor
            
            statusLable.text = "已取消"
        } else if model.status.int == 3 {
            cancelButton.isHidden = true
            
            statusLable.text = "活动结束"
        } else if model.status.int == 5 {
            cancelButton.isHidden = true
            statusLable.text = "已下架"
        } else {
            cancelButton.isHidden = true
            statusLable.text = ""
        }
        
        acitivityTitle.dataModel = model
        acitivityTitle.snp.remakeConstraints { make in
            make.top.equalTo(statusLable.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
        }
        
        acitivityApplyInfo.dataModel = model.user
        acitivityApplyInfo.snp.remakeConstraints { make in
            make.top.equalTo(acitivityTitle.snp.bottom).offset(32)
            make.left.right.equalToSuperview()
        }
        
        var lastView: UIView = acitivityApplyInfo
        
        if !model.tips.isEmpty {
            acitivityTips.isHidden = false
            acitivityTips.tipsText = model.tips
            acitivityTips.snp.remakeConstraints { make in
                make.top.equalTo(acitivityApplyInfo.snp.bottom).offset(32)
                make.left.right.equalToSuperview()
            }
            acitivityTips.layoutIfNeeded()
            lastView = acitivityTips
        } else {
            acitivityTips.isHidden = true
        }
        
        cancelButton.snp.remakeConstraints { make in
            make.top.equalTo(lastView.snp.bottom).offset(32)
            make.width.equalTo(178)
            make.height.equalTo(42)
            make.centerX.equalToSuperview()
            
            make.bottom.equalToSuperview().offset(-46)
        }
    }
    
    @objc func clickCancelBtn() {
        self.block?()
    }
    
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        selectionStyle = .none
        
        contentView.addSubview(statusLable)
        contentView.addSubview(acitivityTitle)
        contentView.addSubview(acitivityApplyInfo)
        contentView.addSubview(acitivityTips)
        contentView.addSubview(cancelButton)
        
        statusLable.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(20)
            make.left.right.equalToSuperview()
            make.height.equalTo(40)
        }
        
        acitivityTitle.snp.makeConstraints { make in
            make.top.equalTo(statusLable.snp.bottom).offset(20)
            make.left.right.equalToSuperview()
        }
        
        acitivityApplyInfo.snp.makeConstraints { make in
            make.top.equalTo(acitivityTitle.snp.bottom).offset(32)
            make.left.right.equalToSuperview()
            
        }
        
        acitivityTips.snp.makeConstraints { make in
            make.top.equalTo(acitivityApplyInfo.snp.bottom).offset(32)
            make.left.right.equalToSuperview()
        }
        acitivityTips.layoutIfNeeded()
        
        cancelButton.snp.makeConstraints { make in
            make.top.equalTo(acitivityTips.snp.bottom).offset(32)
            make.width.equalTo(178)
            make.height.equalTo(42)
            make.centerX.equalToSuperview()
            
            make.bottom.equalToSuperview().offset(-46)
        }
    }
}
