//
//  YHGCInformationFillTipsAlertView.swift
//  galaxy
//
//  Created by alexzzw on 2024/12/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCInformationFillTipsAlertView: YHInformationFillTipsAlertView {
    
    override class func showCheckView(callBack: @escaping Block) {
        let view = YHGCInformationFillTipsAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.block = callBack
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
        
        gloabView = view
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        homeTableView.register(YHGCInformationFillTipsCell.self, forCellReuseIdentifier: YHGCInformationFillTipsCell.cellReuseIdentifier)
    }
    
    @MainActor required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHGCInformationFillTipsCell.self)
        cell.selectionStyle = .none
        return cell
    }

}
