//
//  BsBaseurlManager.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/17.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

// MARK: - 管理项目开发中需要使用到的域名地址
class YHBaseUrlManager {
    // 单例
    static let shared = YHBaseUrlManager()
    
    // 测试环境
    static let baseUrlForTest: String = "https://test-app-go-api.galaxy-immi.com" // APP 使用域名
    // 正式环境
    static let baseUrlForRelease: String = "https://app-go-api.galaxy-immi.com"
    // UAT灰度环境
    static let baseUrlForUat: String = "https://uat-go-api.galaxy-immi.com"
    
    func curURL() -> String {
#if DEBUG
        return YHBaseUrlManager.baseUrlForTest + "/"
#elseif TESTENV
        return YHBaseUrlManager.baseUrlForTest + "/"
#elseif UATENV
        return YHBaseUrlManager.baseUrlForUat + "/"
#else
        return YHBaseUrlManager.baseUrlForRelease + "/"
#endif
    }
    
    // 高专留续签
    func renewalURL() -> String {
#if DEBUG
        return "https://test-unih5.galaxy-immi.com" + "/#/"
#elseif TESTENV
        return "https://test-unih5.galaxy-immi.com" + "/#/"
#elseif UATENV
        return "https://unih5.galaxy-immi.com" + "/#/"
#else
        return "https://unih5.galaxy-immi.com" + "/#/"
#endif
    }
    
    // ossUrl
    func curOssURL() -> String {
        return YHConfigManager.shared.ossUrl
    }
    
    // h5Url
    func curH5URL() -> String {
        return YHConfigManager.shared.h5Url
    }
    
    func supportH5URL() -> String {
        return YHConfigManager.shared.supportH5Url
    }
    
    func businessH5Url() -> String {
        var url = ""
#if DEBUG
        url = "https://test-businessh5.galaxy-immi.com"
#elseif TESTENV
        url = "https://test-businessh5.galaxy-immi.com"
#elseif UATENV
        url = "https://businessh5.galaxy-immi.com"
#else
        url = "https://businessh5.galaxy-immi.com"
#endif
        return url
    }
    
    // 隐私协议 PrivacyAgreement
    func curPrivacyAgreementUrl() -> String {
        return curH5URL() + "superApp/ganglife"
    }
    
    // 用户政策 UserItems
    func curUserItemsUrl() -> String {
        return curH5URL() + "superApp/service"
    }
    
    // 生意星
    func curBusinessStarUrl() -> String {
        var url = ""
#if DEBUG
        url = "https://test-businessh5.galaxy-immi.com/pre-sale/business"
#elseif TESTENV
        url = "https://test-businessh5.galaxy-immi.com/pre-sale/business"
#elseif UATENV
        url = "https://businessh5.galaxy-immi.com/pre-sale/business"
#else
        url = "https://businessh5.galaxy-immi.com/pre-sale/business"
#endif
        return url
    }
    
    // 生意星
    func curBusinessStarStoreUrl() -> String {
        var url = ""
#if DEBUG
        url = "https://test-businessh5.galaxy-immi.com/pre-sale/store"
#elseif TESTENV
        url = "https://test-businessh5.galaxy-immi.com/pre-sale/store"
#elseif UATENV
        url = "https://businessh5.galaxy-immi.com/pre-sale/store"
#else
        url = "https://businessh5.galaxy-immi.com/pre-sale/store"
#endif
        return url
    }
}
