//
//  YHHKRecordsTimeSelectCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHHKRecordsTimeSelectCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHHKRecordsTimeSelectCell"
    private let placeholderColor = UIColor.mainTextColor30
    private let selectedColor = UIColor.mainTextColor
    
    private lazy var asteriskIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "asterisk_icon_6")
        return view
    }()
    
    private lazy var arrowIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "right_arrow_black_20")
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 14)
        label.textColor = UIColor(hexString: "#222222")
        return label
    }()
    
    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.font = .PFSC_M(ofSize: 14)
        return label
    }()
    
    private lazy var bottomLineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()

    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String?, detail: String?, placeholder: String) {
        infoTitleLabel.text = title
        if let detail = detail {
            infoDetailLabel.text = detail
            infoDetailLabel.textColor = selectedColor
        } else {
            infoDetailLabel.text = placeholder
            infoDetailLabel.textColor = placeholderColor
        }
        
    }
}

extension YHHKRecordsTimeSelectCell {
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(asteriskIcon)
        subContainerView.addSubview(infoTitleLabel)
        subContainerView.addSubview(infoDetailLabel)
        subContainerView.addSubview(arrowIcon)
        subContainerView.addSubview(bottomLineView)
        
        infoTitleLabel.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoDetailLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        asteriskIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        arrowIcon.setContentCompressionResistancePriority(.required, for: .horizontal)
        
        asteriskIcon.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(6)
        }
        
        arrowIcon.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalToSuperview().offset(-18)
            make.width.height.equalTo(20)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(asteriskIcon.snp.right).offset(2)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        infoDetailLabel.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.centerX.equalToSuperview().priority(.high)
            make.left.greaterThanOrEqualTo(infoTitleLabel.snp.right).offset(4).priority(.required)
        }
        
        bottomLineView.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.left.equalToSuperview().offset(18)
            make.right.equalToSuperview().offset(-18)
            make.height.equalTo(0.5)
        }
    }
}
