//
//  YHResignDocumentUploadFileCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/10/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignDocumentUploadFileCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHResignDocumentUploadFileCell"
    
    var editButtonClickEvent: (() -> Void)?
    
    private lazy var fileIconView: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "my_cer_type_word")
        return view
    }()
    
    private lazy var fileNameLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor(hexString: "#222222")
        label.font = .PFSC_M(ofSize: 14)
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var editButton: UIButton = {
        let button = UIButton(type: .custom)
        button.setBackgroundImage(UIImage(named: "my_cer_btn_edit"), for: .normal)
        button.addTarget(self, action: #selector(editButtonClicked), for: .touchUpInside)
        return button
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(_ fileName: String, cellType: YHResignRoundCellType = .mid) {
        fileNameLabel.text = fileName
        updateFileIcon(fileName)
        updateCellCorner(cellType)
    }

}

extension YHResignDocumentUploadFileCell {
    
    @objc private func editButtonClicked() {
        editButtonClickEvent?()
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(fileIconView)
        subContainerView.addSubview(fileNameLabel)
        subContainerView.addSubview(editButton)
        
        editButton.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-18)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(16)
        }
        
        fileIconView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(24)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(31)
        }
        
        fileNameLabel.snp.makeConstraints { make in
            make.top.greaterThanOrEqualToSuperview().offset(16)
            make.left.equalTo(fileIconView.snp.right).offset(12)
            make.right.lessThanOrEqualTo(editButton.snp.left).offset(-10)
            make.centerY.equalToSuperview()
            make.bottom.lessThanOrEqualToSuperview().offset(-16)
        }
        editButton.YH_clickEdgeInsets = UIEdgeInsets(top: 10, left: 10, bottom: 10, right: 10)
        
    }
    
    private func updateFileIcon(_ fileName: String) {
        let suffix = fileName.pathExtension.lowercased()
        var iconImgName = ""
        if suffix == "jpeg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "jpg" {
            iconImgName = "my_cer_type_jpg"
        } else if suffix == "png" {
            iconImgName = "my_cer_type_png"
        } else if suffix == "pdf" {
            iconImgName = "my_cer_type_pdf"
        } else if suffix == "doc" || suffix == "docx" {
            iconImgName = "my_cer_type_word"
        } else if suffix == "ppt" || suffix == "pptx" {
            iconImgName = "my_cer_type_ppt"
        } else if suffix == "bmp" {
            iconImgName = "my_cer_type_bmp"
        } else if suffix == "tiff" {
            iconImgName = "my_cer_type_tiff"
        } else if suffix == "xls" || suffix == "xlsx" {
            iconImgName = "my_cer_type_excel"
        }
        fileIconView.image = UIImage(named: iconImgName)
    }
}
