//
//  YHAllowSettingTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/6/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAllowSettingTableViewCell: UITableViewCell {
    typealias ItemBlock = (_ model: YHSettingItem) -> Void
    var block: ItemBlock?
    var titleLabel: UILabel!
    var exampleButton: UIButton!
    var subTitleLabel: UILabel!
    var detailSwitch: UISwitch!
    var item: YHSettingItem? {
        didSet {
            updateData()
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 16)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        contentView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.top.equalTo(16)
            make.height.equalTo(22)
        }
        
        exampleButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "my_card_set_alert"), for: .normal)
            button.addTarget(self, action: #selector(exampleClick), for: .touchUpInside)
            return button
        }()
        contentView.addSubview(exampleButton)
        exampleButton.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.centerY.equalTo(titleLabel.snp.centerY)
            make.height.equalTo(18)
            make.width.equalTo(18)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 13)
            label.textColor = UIColor.brandGrayColor5
            label.numberOfLines = 0
            return label
        }()
        contentView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-87)
            make.top.equalTo(46)
        }
        
        detailSwitch = {
            let switchView = UISwitch()
            switchView.onTintColor =  UIColor.brandGrayColor8
            switchView.addTarget(self, action: #selector(switchViewChange), for: .valueChanged)
            return switchView
        }()
        contentView.addSubview(detailSwitch)
        detailSwitch.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.centerY.equalToSuperview()
            make.height.equalTo(22)
            make.width.equalTo(40)
        }
        exampleButton.YH_clickEdgeInsets = UIEdgeInsets(top: 50, left: 50, bottom: 50, right: 50)
        detailSwitch.transform = CGAffineTransform(scaleX: 0.77, y: 0.77)
    }
    
    @objc func exampleClick() {
        guard let model = item else { return }
        let view = YHSetExplainView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        view.type = model.type
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    @objc func switchViewChange() {
        guard let model = item else { return }
        switch model.type {
        case .normal: 
            model.isSelect = detailSwitch.isOn
            if let block = block {
                block(model)
            }
        case .people:
            if !detailSwitch.isOn {
                YHGrayCommonAlertView.show("", "关闭后，您的信息将不会被展示在公开的人脉列表中", "仍然关闭", "开启", fullGuestureEnable: false) {
                    self.detailSwitch.isOn = false
                    model.isSelect = self.detailSwitch.isOn
                    if let block = self.block {
                        block(model)
                    }
                } callBack: {
                    model.isSelect = self.detailSwitch.isOn
                    self.detailSwitch.isOn = true
                    if let block = self.block {
                        block(model)
                    }
                }
            } else {
                model.isSelect = detailSwitch.isOn
                if let block = block {
                    block(model)
                }
            }
        case .schoolToFriend:
            if !detailSwitch.isOn {
                YHGrayCommonAlertView.show("", "关闭后，您的好友将无法从您的名片中查看您的教育经历", "仍然关闭", "开启", fullGuestureEnable: false) {
                    self.detailSwitch.isOn = false
                    model.isSelect = self.detailSwitch.isOn
                    if let block = self.block {
                        block(model)
                    }
                } callBack: {
                    model.isSelect = self.detailSwitch.isOn
                    self.detailSwitch.isOn = true
                    if let block = self.block {
                        block(model)
                    }
                }
            } else {
                model.isSelect = detailSwitch.isOn
                if let block = block {
                    block(model)
                }
            }
        case .workToFriend:
            if !detailSwitch.isOn {
                YHGrayCommonAlertView.show("", "关闭后，您的好友将无法从您的名片中查看您的工作经历", "仍然关闭", "开启", fullGuestureEnable: false) {
                    self.detailSwitch.isOn = false
                    model.isSelect = self.detailSwitch.isOn
                    if let block = self.block {
                        block(model)
                    }
                } callBack: {
                    model.isSelect = self.detailSwitch.isOn
                    self.detailSwitch.isOn = true
                    if let block = self.block {
                        block(model)
                    }
                }
            } else {
                model.isSelect = detailSwitch.isOn
                if let block = block {
                    block(model)
                }
            }
        case .schoolToStranger:
            if !detailSwitch.isOn {
                YHGrayCommonAlertView.show("", "关闭后，非您的好友将无法从您的名片中查看您的教育经历", "仍然关闭", "开启", fullGuestureEnable: false) {
                    self.detailSwitch.isOn = false
                    model.isSelect = self.detailSwitch.isOn
                    if let block = self.block {
                        block(model)
                    }
                } callBack: {
                    model.isSelect = self.detailSwitch.isOn
                    self.detailSwitch.isOn = true
                    if let block = self.block {
                        block(model)
                    }
                }
            } else {
                model.isSelect = detailSwitch.isOn
                if let block = block {
                    block(model)
                }
            }
        case .workToStranger:
            if !detailSwitch.isOn {
                YHGrayCommonAlertView.show("", "关闭后，非您的好友将无法从您的名片中查看您的工作经历", "仍然关闭", "开启", fullGuestureEnable: false) {
                    self.detailSwitch.isOn = false
                    model.isSelect = self.detailSwitch.isOn
                    if let block = self.block {
                        block(model)
                    }
                } callBack: {
                    model.isSelect = self.detailSwitch.isOn
                    self.detailSwitch.isOn = true
                    if let block = self.block {
                        block(model)
                    }
                }
            } else {
                model.isSelect = detailSwitch.isOn
                if let block = block {
                    block(model)
                }
            }
        }
    }
    
    func updateData() {
        guard let model = item else { return }
        titleLabel.text = model.title
        subTitleLabel.text = model.subTitle
        exampleButton.isHidden = !model.isShowAlert
        detailSwitch.isOn = model.isSelect
    }
}
