//
//  YHActivitySignSuccessViewController.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHActivitySignSuccessViewController: YHBaseViewController {
    
    private let tableView = UITableView(frame: .zero, style: .grouped)
    private var hasPrize: Bool = false
    private var prize: Prize?
    private var event: CheckInEvent?
    
    lazy var backImgV: UIImageView = {
       let v = UIImageView()
       v.image = UIImage(named: "salon_result_bg")
       return v
    }()
    
    lazy var bottomLogoView: UIView = {
        let v = UIView()
        let logoImgV: UIImageView = UIImageView(image: UIImage(named: "salon_logo"))
        v.addSubview(logoImgV)
        logoImgV.snp.makeConstraints { make in
            make.width.equalTo(133)
            make.height.equalTo(26)
            make.centerX.equalToSuperview()
            make.bottom.equalTo(-16)
        }
        return v
    }()
    
    lazy var signFailBgView: UIView = {
        let v = UIView()
        let imgV = UIImageView(image: UIImage(named: "salon_fail_icon"))
        v.addSubview(imgV)
        
        let titleLabel = UILabel()
        titleLabel.font = .PFSC_B(ofSize: 18)
        titleLabel.textColor = .brandGrayColor8
        titleLabel.textAlignment = .center
        titleLabel.text = "签到失败"
        v.addSubview(titleLabel)
        
        let detailLabel = UILabel()
        detailLabel.font = .PFSC_R(ofSize: 14)
        detailLabel.textColor = .brandGrayColor6
        detailLabel.textAlignment = .center
        detailLabel.text = "活动已结束或因其他未知原因，详情请咨询现场顾问"
        v.addSubview(detailLabel)
        
        imgV.snp.makeConstraints { make in
            make.width.height.equalTo(128)
            make.top.equalTo(100)
            make.centerX.equalToSuperview()
        }
        titleLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(25)
            make.top.equalTo(imgV.snp.bottom)
        }
        detailLabel.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.height.equalTo(25)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        return v
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        setupWithPrize() // 切换到 setupWithoutPrize() 查看无奖品情况
    }
    
    private func setupUI() {
        view.backgroundColor =  .contentBkgColor
        view.addSubview(backImgV)
        view.addSubview(signFailBgView)

        tableView.delegate = self
        tableView.dataSource = self
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.register(YHSignPrizeCell.self, forCellReuseIdentifier: YHSignPrizeCell.cellReuseIdentifier)
        tableView.register(YHSignActivityInfoCell.self, forCellReuseIdentifier: YHSignActivityInfoCell.cellReuseIdentifier)
        view.addSubview(tableView)
        view.addSubview(bottomLogoView)
        
        tableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.equalToSuperview()
            make.bottom.equalTo(bottomLogoView.snp.top)
        }
        bottomLogoView.snp.makeConstraints { make in
            make.height.equalTo(58)
            make.left.right.equalToSuperview()
            make.bottom.equalTo(-k_Height_safeAreaInsetsBottom())
        }
        backImgV.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(backImgV.snp.width).multipliedBy(422.0/375.0)
        }
        signFailBgView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    // 有奖品的情况
    private func setupWithPrize() {
        hasPrize = true
        prize = Prize(
            greeting: "你好，侯林先生",
            instruction: "请联系现场工作人员领取您的奖品",
            image: "prize_sofa"
        )
        event = CheckInEvent(
            title: "翱翔云端·探索无限2025无人机创新科技沙龙2025无人机创新科技沙龙2025无人机创新科技沙龙2025无人机创新科技沙龙2025无人机创新科技沙龙2025无人机创新科技沙龙2025无人机创新科技沙龙2025无人机创新科技沙龙2025无人机创新科技沙龙",
            subtitle: "2025无人机创新科技沙龙",
            date: "2025-09-13  周六  09:30",
            location: "银河集团香港体验中心（香港湾仔港湾道26号华润大厦27楼2705室）",
            subLocation: "请于机导航至银河集团香港体验中心",
            thumbnailImage: "event_thumb"
        )
        tableView.reloadData()
    }
    
    // 无奖品的情况
    private func setupWithoutPrize() {
        hasPrize = false
        prize = nil
        event = CheckInEvent(
            title: "翱翔云端·探索无限",
            subtitle: "2025无人机创新科技沙龙",
            date: "2024-08-06  周日  09:30",
            location: "本元大厦26A银河集团体验中心",
            subLocation: "距地铁10号线亮马站D口步行62",
            thumbnailImage: "event_thumb"
        )
        tableView.reloadData()
    }
}

// MARK: - UITableViewDelegate & DataSource
extension YHActivitySignSuccessViewController: UITableViewDelegate, UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if hasPrize {
            return 2 // 标题 + 奖品 + 活动信息
        } else {
            return 1 // 标题 + 活动信息
        }
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        if hasPrize {
            if indexPath.row == 0 {
                // 奖品 Cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignPrizeCell.cellReuseIdentifier, for: indexPath) as? YHSignPrizeCell else {
                    return UITableViewCell()
                }
                if let prize = prize {
                    cell.configure(with: prize)
                }
                return cell
            } else {
                // 活动信息 Cell
                guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignActivityInfoCell.cellReuseIdentifier, for: indexPath) as? YHSignActivityInfoCell else {
                    return UITableViewCell()
                }
                if let event = event {
                    cell.configure(with: event)
                }
                return cell
            }
        } else {
            // 无奖品时，第二个就是活动信息 Cell
            guard let cell = tableView.dequeueReusableCell(withIdentifier: YHSignActivityInfoCell.cellReuseIdentifier, for: indexPath) as? YHSignActivityInfoCell else {
                return UITableViewCell()
            }
            if let event = event {
                cell.configure(with: event)
            }
            return cell
        }
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = YHSignSuccessHeaderView()
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 83
    }
}
