//
//  YHSignPrizeCellTableViewCell.swift
//  galaxy
//
//  Created by Dufet on 2025/10/14.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSignPrizeCell: UITableViewCell {
    static let cellReuseIdentifier = "YHSignPrizeCell"
    
    private let containerView = UIView()
    private let greetingLabel = UILabel()
    private let instructionLabel = UILabel()
    private let prizeImageView = UIImageView()
    private let overlayButton = UIButton()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        backgroundColor = .clear
        selectionStyle = .none
        
        containerView.backgroundColor = .white
        containerView.layer.cornerRadius = 6
        contentView.addSubview(containerView)
        
        greetingLabel.font = .PFSC_B(ofSize: 18)
        greetingLabel.textColor = .brandGrayColor8
        containerView.addSubview(greetingLabel)
        
        instructionLabel.font = .PFSC_R(ofSize: 14)
        instructionLabel.textColor = .brandGrayColor7
        containerView.addSubview(instructionLabel)
        
        prizeImageView.contentMode = .scaleAspectFill
        prizeImageView.clipsToBounds = true
        prizeImageView.layer.cornerRadius = 6
        prizeImageView.backgroundColor = .red
        containerView.addSubview(prizeImageView)
        
        containerView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(0)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(0)
        }
        
        greetingLabel.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(28)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
        }
        
        instructionLabel.snp.makeConstraints { make in
            make.top.equalTo(greetingLabel.snp.bottom).offset(8)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
        }
        
        prizeImageView.snp.makeConstraints { make in
            make.top.equalTo(instructionLabel.snp.bottom).offset(12)
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.bottom.equalToSuperview().offset(-20)
            make.height.equalTo(295)
        }
    }
    
    func configure(with prize: Prize) {
        greetingLabel.text = prize.greeting
        instructionLabel.text = prize.instruction
        if let image = UIImage(named: prize.image) {
            prizeImageView.image = image
        }
    }
}
