//
//  YHPlanShareView.swift
//  galaxy
//
//  Created by Dufet on 2025/3/29.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPlanShareView: UIView {
    
    let wechatBtnTag = 9527
    let copyLinkTag = 9528
    let saveImgTag = 9529
    let cancelTag = 9530
    
    var type: YHPlanShareBgType = .link {
        didSet {
            if type == .link {
                copyLinkBtn.isHidden = false
                saveBtn.isHidden = true
                
            } else if type == .pdf {
                copyLinkBtn.isHidden = true
                saveBtn.isHidden = false
            }
        }
    }
    
    var clickBlock: ((YHPlanShareBgType, YHPlanShareItemButtonType) -> Void)?

    lazy var whiteContentView: UIView = {
        let v = UIView()
        v.backgroundColor = .white
        v.layer.cornerRadius = 12.0
        v.clipsToBounds = true
        return v
    }()
    
    lazy var cancelBtn: UIButton = {
        let btn = UIButton()
        btn.tag = cancelTag
        btn.backgroundColor = .init(hex: 0xF5F6F8)
        btn.setTitle("取消", for: .normal)
        btn.setTitleColor(.mainTextColor, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 16)
        btn.layer.cornerRadius = 3.0
        btn.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return btn
    }()
    
    lazy var wechatBtn: YHPlanShareItemButton = {
        let v = YHPlanShareItemButton()
        v.tag = wechatBtnTag
        v.textLabel.text = "微信"
        v.iconImgV.image = UIImage(named: "plan_share_wechat")
        v.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return v
    }()
    
    lazy var copyLinkBtn: YHPlanShareItemButton = {
        let v = YHPlanShareItemButton()
        v.tag = copyLinkTag
        v.textLabel.text = "复制链接"
        v.iconImgV.image = UIImage(named: "plan_share_copy")
        v.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return v
    }()
    
    lazy var saveBtn: YHPlanShareItemButton = {
        let v = YHPlanShareItemButton()
        v.tag = saveImgTag
        v.textLabel.text = "保存PDF"
        v.iconImgV.image = UIImage(named: "plan_share_save")
        v.isHidden = true
        v.addTarget(self, action: #selector(didFunctionBtnClicked(_:)), for: .touchUpInside)
        return v
    }()
    
    @objc func didFunctionBtnClicked(_ sender: UIButton) {
        
        if sender.tag == wechatBtnTag {
            clickBlock?(type, .wechat)
            
        } else if sender.tag == copyLinkTag {
            clickBlock?(type, .copyLink)

        } else if sender.tag == saveImgTag {
            clickBlock?(type, .saveImg)

        } else if sender.tag == cancelTag {
            clickBlock?(type, .cancel)
        }
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(wechatBtn)
        whiteContentView.addSubview(copyLinkBtn)
        whiteContentView.addSubview(saveBtn)
        whiteContentView.addSubview(cancelBtn)

        whiteContentView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        copyLinkBtn.snp.makeConstraints { make in
            make.width.equalTo(64)
            make.height.equalTo(74)
            make.top.equalTo(20)
            make.left.equalTo(self.snp.centerX).offset(35)
        }
        
        saveBtn.snp.makeConstraints { make in
            make.width.equalTo(64)
            make.height.equalTo(74)
            make.center.equalTo(copyLinkBtn)
        }
        
        wechatBtn.snp.makeConstraints { make in
            make.width.equalTo(64)
            make.height.equalTo(74)
            make.top.equalTo(20)
            make.right.equalTo(self.snp.centerX).offset(-35)
        }
        
        cancelBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(46)
            make.top.equalTo(copyLinkBtn.snp.bottom).offset(20)
        }
    }
}
