//
//  YHResourceDetailDemandCell.swift
//  galaxy
//
//  Created by alexzzw on 2025/9/30.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResourceDetailDemandCell: UITableViewCell {
    
    private lazy var dividerView: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.brandGrayColor3
        return view
    }()
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 17)
        label.textColor = UIColor.brandGrayColor8
        label.text = "企业需求"
        return label
    }()
    
    private lazy var demandTitleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textColor = UIColor.brandGrayColor6
        label.text = "近期需求"
        return label
    }()
    
    private lazy var demandContentLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.textColor = UIColor.brandGrayColor8
        label.numberOfLines = 0
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func setupUI() {
        selectionStyle = .none
        backgroundColor = .white
        contentView.backgroundColor = .white
        
        contentView.addSubview(titleLabel)
        contentView.addSubview(dividerView)
        contentView.addSubview(demandTitleLabel)
        contentView.addSubview(demandContentLabel)
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.right.equalToSuperview().offset(-20)
            make.top.equalToSuperview().offset(24)
        }
                
        demandTitleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(20)
            make.top.equalTo(titleLabel.snp.bottom).offset(16)
            make.width.equalTo(70)
        }
        
        demandContentLabel.snp.makeConstraints { make in
            make.left.equalTo(demandTitleLabel.snp.right).offset(12)
            make.right.equalToSuperview().offset(-20)
            make.top.equalTo(demandTitleLabel)
        }
        
        dividerView.snp.makeConstraints { make in
            make.left.right.equalToSuperview().inset(20)
            make.top.equalTo(demandContentLabel.snp.bottom).offset(24)
            make.height.equalTo(1)
            make.bottom.equalToSuperview()
        }
    }
    
    func configure(with model: YHResourceDetailModel) {
        // 使用详情接口的 demand_published 字段
        demandContentLabel.text = model.demand_published.isEmpty ? "未填写" : model.demand_published
    }
}
