//
//  YHGCMainInformationCardTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/12/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHGCMainInformationCardTableViewCell: UITableViewCell {
    typealias InformationBlock = (_ type: YHCardType, _ image: UIImage, _ isleft: Bool) -> Void
    var informationBlock: InformationBlock?
    var centerView: UIView!
    var titleLabel: UILabel!
    var exampleButton: UIButton!
    var frontLabel: UILabel!
    var backSurfaceLabel: UILabel!
    var frontImageButton: YHCardButton!
    var backSurfaceImageButton: YHCardButton!
    var frontDeleteButton: UIButton!
    var backSurfaceDeleteButton: UIButton!
    var activityIndicator: UIActivityIndicatorView!
    var viewModel: YHGCMainApplicantInformationViewModel! {
        didSet {
            if type == .identity {
                if viewModel.mainModel.certificates.cn_identity_card.img_front.count != 0 {
                    self.viewModel.getPublicImageUrl(viewModel.mainModel.certificates.cn_identity_card.img_front) {[weak self] success, _ in
                        guard let self = self else { return }
                        guard let url = success else { return }
                        self.frontImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                            self.frontDeleteButton.isHidden = false
                        })
                        self.frontImageButton.setContent("", "")
                    }
                }
                if viewModel.mainModel.certificates.cn_identity_card.img_back.count != 0 {
                    self.viewModel.getPublicImageUrl(viewModel.mainModel.certificates.cn_identity_card.img_back) {[weak self] success, _ in
                        guard let self = self else { return }
                        guard let url = success else { return }
                        self.backSurfaceImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                            self.backSurfaceDeleteButton.isHidden = false
                        })
                        self.backSurfaceImageButton.setContent("", "")
                    }
                }
            } else if type == .passport {
                if viewModel.mainModel.certificates.hk_macao_pass.img_front.count != 0 {
                    self.viewModel.getPublicImageUrl(viewModel.mainModel.certificates.hk_macao_pass.img_front) {[weak self] success, _ in
                        guard let self = self else { return }
                        guard let url = success else { return }
                        self.frontImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                            self.frontDeleteButton.isHidden = false
                        })
                        self.frontImageButton.setContent("", "")
                    }
                }
                if viewModel.mainModel.certificates.hk_macao_pass.img_back.count != 0 {
                    self.viewModel.getPublicImageUrl(viewModel.mainModel.certificates.hk_macao_pass.img_back) {[weak self] success, _ in
                        guard let self = self else { return }
                        guard let url = success else { return }
                        self.backSurfaceImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                            self.backSurfaceDeleteButton.isHidden = false
                        })
                        self.backSurfaceImageButton.setContent("", "")
                    }
                }
            } else {
                if viewModel.mainModel.certificates.passport.img_front.count != 0 {
                    self.viewModel.getPublicImageUrl(viewModel.mainModel.certificates.passport.img_front) {[weak self] success, _ in
                        guard let self = self else { return }
                        guard let url = success else { return }
                        self.frontImageButton.kf.setBackgroundImage(with: URL(string: url), for: .normal, completionHandler: { _ in
                            self.frontDeleteButton.isHidden = false
                        })
                        self.frontImageButton.setContent("", "")
                    }
                }
            }
        }
    }
    var type: YHCardType = .identity {
        didSet {
            switch type {
            case .identity:
                titleLabel.text = "中国身份证(选填)"
                frontLabel.text = "身份证人像面"
                backSurfaceLabel.text = "身份证国徽面"
                frontImageButton.setBackgroundImage(UIImage(named: "service_cn_card_front"), for: .normal)
                backSurfaceImageButton.setBackgroundImage(UIImage(named: "service_cn_card_back"), for: .normal)
                backSurfaceLabel.isHidden = false
                backSurfaceImageButton.isHidden = false
            case .passport:
                titleLabel.text = "港澳通行证(选填)"
                frontLabel.text = "港澳通行证正面"
                backSurfaceLabel.text = "港澳通行证反面"
                frontImageButton.setBackgroundImage(UIImage(named: "service_hk_card_front"), for: .normal)
                backSurfaceImageButton.setBackgroundImage(UIImage(named: "service_hk_card_back"), for: .normal)
                backSurfaceLabel.isHidden = false
                backSurfaceImageButton.isHidden = false
            case .other:
                titleLabel.text = "护照(选填)"
                frontLabel.text = "护照资料页"
                backSurfaceLabel.isHidden = true
                frontImageButton.setBackgroundImage(UIImage(named: "service_hk_card_front"), for: .normal)
                backSurfaceImageButton.isHidden = true
            }
        }
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = .clear
        backgroundColor = .clear
        
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-16)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(20)
        }
        
        exampleButton = {
            let button = UIButton(type: .custom)
            button.backgroundColor =  UIColor.brandMainColor.withAlphaComponent(0.08)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 10)
            button.contentHorizontalAlignment = .center
            button.setTitle("示例模板", for: .normal)
            button.setTitleColor( UIColor.brandMainColor, for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.addTarget(self, action: #selector(exampleClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(exampleButton)
        exampleButton.snp.makeConstraints { make in
            make.left.equalTo(titleLabel.snp.right).offset(8)
            make.centerY.equalTo(titleLabel.snp.centerY)
            make.height.equalTo(14)
            make.width.equalTo(48)
        }
        
        let lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(52)
            make.height.equalTo(1)
            make.right.equalTo(-18)
        }
        
        frontLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.subTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(frontLabel)
        frontLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.width.equalTo(147)
            make.top.equalTo(64)
            make.height.equalTo(20)
        }
        
        backSurfaceLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.subTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(backSurfaceLabel)
        backSurfaceLabel.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.width.equalTo(147)
            make.top.equalTo(64)
            make.height.equalTo(20)
        }
        
        frontImageButton = {
            let button = YHCardButton()
            button.setContent("card_upload", "点击上传")
            button.setBackgroundImage(UIImage(named: "service_cn_card_front"), for: .normal)
            button.addTarget(self, action: #selector(frontImageClick), for: .touchUpInside)
            button.layer.cornerRadius = 4
            button.clipsToBounds = true
            return button
        }()
        centerView.addSubview(frontImageButton)
        frontImageButton.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(96)
            make.height.equalTo(91)
            make.width.equalTo(147)
        }
        
        frontDeleteButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_delete"), for: .normal)
            button.addTarget(self, action: #selector(frontDeleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        centerView.addSubview(frontDeleteButton)
        frontDeleteButton.snp.makeConstraints { make in
            make.centerX.equalTo(frontImageButton.snp.right)
            make.centerY.equalTo(frontImageButton.snp.top)
            make.height.equalTo(21)
            make.width.equalTo(21)
        }
        
        backSurfaceImageButton = {
            let button = YHCardButton()
            button.setContent("card_upload", "点击上传")
            button.setBackgroundImage(UIImage(named: "service_cn_card_back"), for: .normal)
            button.addTarget(self, action: #selector(backSurfaceImageClick), for: .touchUpInside)
            button.layer.cornerRadius = 4
            button.clipsToBounds = true
            return button
        }()
        centerView.addSubview(backSurfaceImageButton)
        backSurfaceImageButton.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.top.equalTo(96)
            make.height.equalTo(91)
            make.width.equalTo(147)
        }

        backSurfaceDeleteButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_delete"), for: .normal)
            button.addTarget(self, action: #selector(backSurfaceDeleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        centerView.addSubview(backSurfaceDeleteButton)
        backSurfaceDeleteButton.snp.makeConstraints { make in
            make.centerX.equalTo(backSurfaceImageButton.snp.right)
            make.centerY.equalTo(backSurfaceImageButton.snp.top)
            make.height.equalTo(21)
            make.width.equalTo(21)
        }
        
        activityIndicator = {
            let view = UIActivityIndicatorView()
            view.style = .medium
            return view
        }()
        centerView.addSubview(activityIndicator)
        activityIndicator.snp.makeConstraints { make in
            make.center.equalTo(backSurfaceImageButton.snp.center)
            make.height.equalTo(25)
            make.width.equalTo(25)
        }
        
        exampleButton.YH_clickEdgeInsets = UIEdgeInsets(top: 50, left: 50, bottom: 50, right: 50)
    }
    
    @objc func exampleClick() {
        if type == .other {
            YHAdopterCardExampleView.exampleView(type: .chinaTravel).show()
        } else {
            let view = YHCardExampleView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
            view.type = type
            let window = UIApplication.shared.yhKeyWindow()
            window?.addSubview(view)
        }
    }
    
    @objc func frontImageClick() {
        if type == .identity {
            if viewModel.mainModel.certificates.cn_identity_card.img_front.count != 0 {
//                let vc = YHImageViewController()
//                vc.imgString = viewModel.mainModel.certificates.cn_identity_card.img_front
//                UIViewController.current?.navigationController?.pushViewController(vc)
                
                if viewModel.mainModel.certificates.cn_identity_card.img_front.isEmpty == false {
                    let vc = YHImageViewController()
                    vc.imgString = viewModel.mainModel.certificates.cn_identity_card.img_front
                    UIViewController.current?.navigationController?.pushViewController(vc)
                }
                return
            }
        } else if type == .passport {
            if viewModel.mainModel.certificates.hk_macao_pass.img_front.count != 0 {
//                let vc = YHImageViewController()
//                vc.imgString = viewModel.mainModel.certificates.hk_macao_pass.img_front
//                UIViewController.current?.navigationController?.pushViewController(vc)
                
                if viewModel.mainModel.certificates.hk_macao_pass.img_front.isEmpty == false {
                    let vc = YHImageViewController()
                    vc.imgString = viewModel.mainModel.certificates.hk_macao_pass.img_front
                    UIViewController.current?.navigationController?.pushViewController(vc)
                }
                
                return
            }
        } else {
            if viewModel.mainModel.certificates.passport.img_front.count != 0 {
                
                if viewModel.mainModel.certificates.passport.img_front.isEmpty == false {
                    let vc = YHImageViewController()
                    vc.imgString = viewModel.mainModel.certificates.passport.img_front
                    UIViewController.current?.navigationController?.pushViewController(vc)
                }
                
                return
            }
        }
        YHImagePickerView.show {[weak self] image in
            guard let self = self else { return }
            self.frontImageButton.setContent("card_loading", "上传中")
            self.frontImageButton.startRotationAnimation()
            self.viewModel.uploadImage(image) {[weak self] success, _ in
                guard let self = self else { return }
                self.frontImageButton.stopRotationAnimation()
                self.frontImageButton.setContent("", "")
                
                guard let url = success else { return }
                self.viewModel.updateModel(self.type, isFront: true, url: url)
                self.frontImageButton.setBackgroundImage(image, for: .normal)
                self.frontDeleteButton.isHidden = false
                
                self.viewModel.getPublicImageUrl(url) {[weak self] success, _ in
                    guard let self = self else { return }
                    guard let url = success else { return }
                    
                    if self.type == .identity {
                        self.viewModel.requestCnIDCardMessage(url, isBack: 0) {[weak self] _, _ in
                        }
                    } else if self.type == .passport {
                        self.viewModel.requestHkIDCardMessage(url, isBack: 0) {[weak self] _, _ in
                        }
                    }
                }
            }
        }
    }
    
    @objc func backSurfaceImageClick() {
        if type == .identity {
            if viewModel.mainModel.certificates.cn_identity_card.img_back.count != 0 {
//                let vc = YHImageViewController()
//                vc.imgString = viewModel.mainModel.certificates.cn_identity_card.img_back
//                UIViewController.current?.navigationController?.pushViewController(vc)
                
                if viewModel.mainModel.certificates.cn_identity_card.img_back.isEmpty == false {
                    let vc = YHImageViewController()
                    vc.imgString = viewModel.mainModel.certificates.cn_identity_card.img_back
                    UIViewController.current?.navigationController?.pushViewController(vc)
                }
                return
            }
        } else {
            if viewModel.mainModel.certificates.hk_macao_pass.img_back.count != 0 {
//                let vc = YHImageViewController()
//                vc.imgString = viewModel.mainModel.certificates.hk_macao_pass.img_back
//                UIViewController.current?.navigationController?.pushViewController(vc)
                
                if viewModel.mainModel.certificates.hk_macao_pass.img_back.isEmpty == false {
                    let vc = YHImageViewController()
                    vc.imgString = viewModel.mainModel.certificates.hk_macao_pass.img_back
                    UIViewController.current?.navigationController?.pushViewController(vc)
                }
                return
            }
        }
        YHImagePickerView.show {[weak self] image in
            guard let self = self else { return }
            self.backSurfaceImageButton.setContent("card_loading", "上传中")
            self.backSurfaceImageButton.startRotationAnimation()
            self.viewModel.uploadImage(image) {[weak self] success, _ in
                guard let self = self else { return }
                self.backSurfaceImageButton.stopRotationAnimation()
                self.backSurfaceImageButton.setContent("", "")
                
                guard let url = success else { return }
                self.backSurfaceImageButton.setBackgroundImage(image, for: .normal)
                self.viewModel.updateModel(self.type, isFront: false, url: url)
                self.backSurfaceDeleteButton.isHidden = false
                self.viewModel.getPublicImageUrl(url) {[weak self] success, _ in
                    guard let self = self else { return }
                    guard let url = success else { return }
                    if self.type == .identity {
                        self.viewModel.requestCnIDCardMessage(url, isBack: 1) {[weak self] _, _ in
                        }
                    } else {
                        self.viewModel.requestHkIDCardMessage(url, isBack: 1 ) {[weak self] _, _ in
                        }
                    }
                }
            }
        }
    }
    
    func updataData() {
        titleLabel.text = "中国身份证(选填)"
        frontLabel.text = "身份证人像面"
        backSurfaceLabel.text = "身份证国徽面"
    }
    
    @objc func frontDeleteClick() {
        viewModel.updateModel(self.type, isFront: true, url: "")
        frontDeleteButton.isHidden = true
        switch type {
        case .identity:
            frontImageButton.setBackgroundImage(UIImage(named: "service_cn_card_front"), for: .normal)
        case .passport:
            frontImageButton.setBackgroundImage(UIImage(named: "service_hk_card_front"), for: .normal)
        case .other:
            frontImageButton.setBackgroundImage(UIImage(named: "service_hk_card_front"), for: .normal)
        }
        frontImageButton.setContent("card_upload", "点击上传")
    }
    
    @objc func backSurfaceDeleteClick() {
        viewModel.updateModel(self.type, isFront: false, url: "")
        backSurfaceDeleteButton.isHidden = true
        switch type {
        case .identity:
            backSurfaceImageButton.setBackgroundImage(UIImage(named: "service_cn_card_back"), for: .normal)
        case .passport:
            backSurfaceImageButton.setBackgroundImage(UIImage(named: "service_hk_card_back"), for: .normal)
        case .other:
            backSurfaceImageButton.setBackgroundImage(UIImage(named: "service_hk_card_back"), for: .normal)
        }
        backSurfaceImageButton.setContent("card_upload", "点击上传")
    }
}
