//
//  YHAddFriendCardCell.swift
//  galaxy
//
//  Created by edy on 2024/6/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHAddFriendCardCell: UITableViewCell {

    static let cellReuseIdentifier = "YHAddFriendCardCell"
    let secondCardColor = UIColor(hex: 0xF0F4FB)
    let thirdCardColor = UIColor(hex: 0xBBBBBB, alpha: 0.1)
    var acceptBlock: ((Bool) -> Void)?
    var cardCount: Int = 1 {
        didSet {
            var firstCardBottomMargin = 0.0
            var secondCardBottomMargin = 0.0
            if self.cardCount <= 1 {
               
            } else if self.cardCount == 2 {
                firstCardBottomMargin = -6.0
                
            } else {
                firstCardBottomMargin = -6.0
                secondCardBottomMargin = -6.0
            }
            self.cardView.snp.updateConstraints { make in
                make.bottom.equalTo(self.secondCardView).offset(firstCardBottomMargin)
            }
            self.secondCardView.snp.updateConstraints { make in
                make.bottom.equalTo(self.thirdCardView).offset(secondCardBottomMargin)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    var friendModel: YHFriendModel = YHFriendModel() {
        didSet {
            if let url = URL(string: self.friendModel.avatar) {
                self.headImgV.kf.setImage(with: url, placeholder: UIImage(named: "people_head_default"))
            } else {
                self.headImgV.image = UIImage(named: "people_head_default")
            }
            self.nameLabel.text = self.friendModel.username
            self.msgLabel.text = self.friendModel.verifyInfo
//            self.signImgV.isHidden = !self.friendModel.isSign
            
            var text1 = ""
            var text1Arr: [String] = []
            if !self.friendModel.position.isEmpty {
                text1Arr.append(self.friendModel.position)
            }
            if !self.friendModel.industry.isEmpty {
                text1Arr.append(self.friendModel.industry)
            }
            if text1Arr.count > 0 {
                text1 = text1Arr.joined(separator: " | ")
            }
            self.professionalLabel.text = text1
            
            self.scrollView.snp.updateConstraints { make in
                let msgHeight = self.getHeight(text: self.friendModel.verifyInfo, font: self.msgLabel.font!, width: KScreenWidth-40.0*2)
                make.height.equalTo(msgHeight >= 72.0 ? 72.0+12.0 : msgHeight+12.0)
            }
        }
    }
    
    static let height = 218.0
    
    lazy var cardView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 3.0
        return view
    }()
    
    lazy var bgImageView: UIImageView = {
        let bgImgView = UIImageView(image: UIImage(named: "people_add_friend_bg"))
        bgImgView.isHidden = true
        return bgImgView
    }()
    
    lazy var headImgV: UIImageView = {
        let view = UIImageView(image: UIImage(named: "people_head_default"))
        view.layer.cornerRadius = 23.0
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    lazy var nameLabel: UILabel = {
        let nameLabel = UILabel()
        nameLabel.textColor = UIColor.mainTextColor
        nameLabel.textAlignment = .left
        nameLabel.font = UIFont.PFSC_B(ofSize: 16)
        return nameLabel
    }()
    
    lazy var signImgV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "people_sign")
        view.isHidden = true
        return view
    }()
    
    lazy var professionalLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor70
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 13)
        return label
    }()
    
    lazy var scrollView: UIScrollView = {
        let view = UIScrollView()
        view.backgroundColor = UIColor(hex: 0xF4F6FA)
        view.layer.cornerRadius = 3.0
        return view
    }()
    
    lazy var scrollContentView: UIView = {
        let view = UIView()
        return view
    }()
    
    lazy var msgLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor50
        label.textAlignment = .left
        label.font = UIFont.PFSC_R(ofSize: 13)
        label.numberOfLines = 0
        return label
    }()
    
    lazy var ignoreBtn: UIButton = {
       let btn = UIButton()
        btn.setTitle("忽略", for: .normal)
        btn.backgroundColor = UIColor(hexString: "#F8F9FB")
        btn.setTitleColor(UIColor(hexString: "#222222"), for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 13.6)
        btn.layer.cornerRadius = 2.75
        btn.addTarget(self, action: #selector(didIgnoreBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var acceptBtn: UIButton = {
       let btn = UIButton()
        btn.setTitle("接受", for: .normal)
        btn.backgroundColor = UIColor.brandGrayColor8
        btn.setTitleColor(UIColor.white, for: .normal)
        btn.titleLabel?.font = .PFSC_M(ofSize: 14)
        btn.layer.cornerRadius = 2.75
        btn.addTarget(self, action: #selector(didAcceptBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var secondCardView: UIView = {
        let view = UIView()
        view.backgroundColor = self.secondCardColor
        view.layer.cornerRadius = 3.0
        return view
    }()
    
    lazy var thirdCardView: UIView = {
        let view = UIView()
        view.backgroundColor = self.thirdCardColor
        view.layer.cornerRadius = 3.0
        return view
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didIgnoreBtnClicked() {
        self.acceptBlock?(false)
    }
    
    @objc func didAcceptBtnClicked() {
        self.acceptBlock?(true)
    }
    
    func createUI() {
        
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        self.contentView.addSubview(thirdCardView)
        self.contentView.addSubview(secondCardView)
        self.contentView.addSubview(cardView)
        
        cardView.addSubview(bgImageView)
        cardView.addSubview(headImgV)
        cardView.addSubview(nameLabel)
        cardView.addSubview(signImgV)
        cardView.addSubview(professionalLabel)
        
        cardView.addSubview(scrollView)
        scrollView.addSubview(scrollContentView)
        scrollContentView.addSubview(msgLabel)
        
        cardView.addSubview(ignoreBtn)
        cardView.addSubview(acceptBtn)
        
        cardView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.bottom.equalTo(self.secondCardView).offset(-6)
        }
        
        bgImageView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        headImgV.snp.makeConstraints { make in
            make.width.height.equalTo(46.0)
            make.left.equalTo(16)
            make.top.equalTo(16)
        }
        
        self.nameLabel.snp.makeConstraints { make in
            make.left.equalTo(self.headImgV.snp.right).offset(10)
            make.height.equalTo(22.0)
            make.top.equalTo(self.headImgV)
        }
        
        self.signImgV.snp.makeConstraints { make in
            make.width.equalTo(49)
            make.height.equalTo(16)
            make.centerY.equalTo(self.nameLabel)
            make.left.equalTo(self.nameLabel.snp.right).offset(8)
            make.right.lessThanOrEqualToSuperview().offset(-16)
        }
        
        self.professionalLabel.snp.makeConstraints { make in
            make.left.equalTo(self.nameLabel)
            make.right.equalTo(-16)
            make.top.equalTo(self.nameLabel.snp.bottom).offset(6)
            make.height.equalTo(18)
        }
        
        self.scrollView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(self.headImgV.snp.bottom).offset(16)
            make.bottom.equalTo(self.ignoreBtn.snp.top).offset(-16)
            make.height.equalTo(62)
        }
        
        self.scrollContentView.snp.makeConstraints { make in
            make.width.equalTo(KScreenWidth-40*2)
            make.left.equalToSuperview().offset(8)
            make.right.equalToSuperview().offset(-8)
            make.top.equalToSuperview().offset(6)
            make.bottom.equalToSuperview().offset(-6)
        }
        self.msgLabel.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        self.ignoreBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.width.equalTo(78)
            make.height.equalTo(40)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        self.acceptBtn.snp.makeConstraints { make in
            make.left.equalTo(self.ignoreBtn.snp.right).offset(10)
            make.right.equalTo(-16)
            make.centerY.equalTo(self.ignoreBtn)
            make.height.equalTo(40)
        }
        
        self.secondCardView.snp.makeConstraints { make in
            make.left.equalTo(self.cardView).offset(5)
            make.right.equalTo(self.cardView).offset(-5)
            make.height.equalTo(6)
            make.bottom.equalTo(self.thirdCardView).offset(-6)
        }
        
        self.thirdCardView.snp.makeConstraints { make in
            make.left.equalTo(self.cardView).offset(10)
            make.right.equalTo(self.cardView).offset(-10)
            make.bottom.equalToSuperview()
            make.height.equalTo(6)
        }
    }
    
    func getHeight(text: String, font: UIFont, width: CGFloat) -> CGFloat {
        let attributes = [NSAttributedString.Key.font: font] as [NSAttributedString.Key: Any]
        let boundingSize = (text as NSString).boundingRect(
            with: CGSize(width: width, height: .greatestFiniteMagnitude),
            options: .usesLineFragmentOrigin,
            attributes: attributes,
            context: nil
        ).size
        
#if targetEnvironment(simulator)
// 这段代码只会在模拟器上编译
print("This is running on a simulator.")
        let textHeight: CGFloat = CGFloat(ceill(Float80(CGFloat(boundingSize.height))))
        return textHeight
#else
// 这段代码只会在真机上编译
print("This is running on a physical device.")
        
        let textHeight: CGFloat = ceill(CGFloat(boundingSize.height))
        return textHeight
#endif
        return 0.0
    }

}
