//
//  YHVisaPaymentListModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

class YHVisaPaymentListModel: SmartCodable {
    var payment_url: String = "" // 支付地址url
    var list: [YHVisaPaymentModel] = []
    required init() {
    }
}

class YHVisaPaymentModel: SmartCodable {
    var id: Int = -1//
    var type: String = ""// 用户类型
    var name: String = ""// 用户姓名
    var file_num: String = ""// 档案号
    var approval_date: String = ""// 获批日期
    var fee_hkd: Int = -1// 缴费金额港币
    var fee_rmb: String = "" // 缴费金额人民币
    var pay_status: Int = -1 // 支付状态 7-待缴费 8-已缴费 9-电子签证已过期
    var min_pay_time: String = ""// 可缴费开始参考时间
    var max_pay_time: String = ""// 可缴费结束参考时间
    var birthday: String = ""// 生日
    var receipt: String = ""// 电子签证地址
    var pay_time: String = "" // 缴费时间
    var want_min_time: String = "" // 意向开始时间
    var want_max_time: String = "" // 意向结束时间
    var go_time: String = ""// 实际赴港时间
    var fee_money: String = "" // 20250226之后用这个缴费金额
    
    required init() {
    }
}

class YHVisaPaymentUpdateStatusModel: SmartCodable {
    var status: Int = 0 // 查询状态：1更新中，0未更新
    required init() {
    }
}
