//
//  YHIncomeRecordCompanyTipsCell.swift
//  galaxy
//
//  Created by alexzzw on 2024/11/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import AttributedString
import UIKit

class YHIncomeRecordCompanyTipsCell: YHResignDocumentCell {
    static let cellReuseIdentifier = "YHIncomeRecordCompanyTipsCell"

    private lazy var infoDetailLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_R(ofSize: 13)
        label.textColor = UIColor(hexString: "#8993A2")
        label.numberOfLines = 0
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(detail: String) {
        infoDetailLabel.text = detail
    }
    
    func setupCellInfo(tipsDetail: ASAttributedString, cellType: YHResignRoundCellType = .mid) {
        infoDetailLabel.attributed.text = tipsDetail
        updateCellCorner(cellType)
        if cellType == .bottom || cellType == .single {
            infoDetailLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.top.equalToSuperview().offset(16)
                make.bottom.equalToSuperview().offset(-16)
                make.right.lessThanOrEqualToSuperview().offset(-18)
            }
        } else {
            infoDetailLabel.snp.remakeConstraints { make in
                make.left.equalToSuperview().offset(18)
                make.top.equalToSuperview().offset(16)
                make.bottom.equalToSuperview()
                make.right.lessThanOrEqualToSuperview().offset(-18)
            }
        }
    }
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(infoDetailLabel)
        infoDetailLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview()
            make.right.lessThanOrEqualToSuperview().offset(-18)
        }
    }
}
