//
//  YHOtherYesOrNoItemView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOtherYesOrNoItemView: UIView, UITextViewDelegate {
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    typealias Block = (Int) -> Void
    var block: Block?
    
    private let btnWidth = 70.0
    private let btnHeight = 32.0
    private let btnTitleSelectColor = UIColor.brandMainColor
    private let btnTitleDefaultColor = UIColor.mainTextColor
    private let btnBgDefaultColor = UIColor.contentBkgColor
    private let btnBgSelectColor = UIColor.brandMainColor.withAlphaComponent(0.08)
    private let answerBaseTag  = 9527
    
    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.lineBreakMode = .byCharWrapping
        return label
    }()
    
    private lazy var answer1Btn: UIButton = {
        
        let btn = UIButton()
        btn.setTitle("否", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var answer2Btn: UIButton = {
        let btn = UIButton()
        btn.setTitle("是", for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(btnTitleDefaultColor, for: .normal)
        btn.backgroundColor = btnBgDefaultColor
        btn.layer.cornerRadius = btnHeight/2.0
        btn.layer.masksToBounds = true
        btn.layer.borderWidth = 1
        btn.layer.borderColor = UIColor.clear.cgColor
        btn.tag = answerBaseTag+1
        btn.addTarget(self, action: #selector(didClickResponseBtn(btn:)), for: .touchUpInside)
        return btn
    }()
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    var title: String? {
        didSet {
            if let question = title {
                let str = "* "+question
                let attributes: [NSAttributedString.Key: Any] = [
                    .font: UIFont.PFSC_R(ofSize: 14),
                    .foregroundColor: UIColor.mainTextColor
                ]
                let questionAttrStr = NSMutableAttributedString(string: str, attributes: attributes)
                let starRange = NSRange(location: 0, length: 1)
                questionAttrStr.addAttribute(NSAttributedString.Key.foregroundColor, value: UIColor.failColor, range: starRange)
                titleLabel.attributedText = questionAttrStr
            }
        }
    }
    private var lastSelectedBtn: UIButton?
    
    var needCheckFlag: Bool = false {
        didSet {
            layoutMyUI()
        }
    }
    
    // 提示lable
    private lazy var noTextTipsLable: UILabel = {
        let label = UILabel()
        label.textColor = .failColor
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.text = "请选择"
        label.isHidden = true
        return label
    }()
}

private extension YHOtherYesOrNoItemView {
    func setupUI() {
        backgroundColor = .clear
        title = "1、您是否有行业内的专业资格证书？"
        addSubview(titleLabel)
        addSubview(answer2Btn)
        addSubview(answer1Btn)
        addSubview(noTextTipsLable)
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(kMargin)
            make.left.right.equalToSuperview()
        }
        
        answer2Btn.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: btnWidth, height: btnHeight))
            make.left.equalTo(titleLabel.snp.left)
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
        }
        
        answer1Btn.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: btnWidth, height: btnHeight))
            make.left.equalTo(answer2Btn.snp.right).offset(12)
            make.top.equalTo(answer2Btn.snp.top)
        }
        
        addSubview(bottomLine)
        bottomLine.snp.makeConstraints { make in
            make.top.equalTo(answer2Btn.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.bottom.equalToSuperview()
        }
        
        layoutMyUI()
    }
    
    @objc func didClickResponseBtn(btn: UIButton) {
        printLog("点击了按钮哈 \(btn.tag)")
        
        if  lastSelectedBtn == btn {
            printLog("连续点击了同一个按钮......")
            return
        }
        
        lastSelectedBtn = btn
        btn.isSelected = true
        updateAnswerButton(btn, true)
        
        if btn == answer1Btn {
            answer2Btn.isSelected = false
            updateAnswerButton(answer2Btn, false)

        } else {
            answer1Btn.isSelected = false
            updateAnswerButton(answer1Btn, false)
        }
        self.block?(answer2Btn.isSelected == true ? 1 : 2)// 是-1 否-2
        
        layoutMyUI()
    }
    
    // 更新答案按钮选中状态
    private func updateAnswerButton(_ btn: UIButton, _ isSelect: Bool) {
        btn.layer.borderColor = (isSelect ? btnTitleSelectColor : .clear).cgColor
        btn.setTitleColor((isSelect ? btnTitleSelectColor : btnTitleDefaultColor), for: .normal)
        btn.backgroundColor = (isSelect ? btnBgSelectColor : btnBgDefaultColor)
    }
}

extension YHOtherYesOrNoItemView {
    func updateUI(title: String, answer: Int) {
        self.title = title
        // 是-1 否-2
        if answer == 2 {
            didClickResponseBtn(btn: answer1Btn)
        } else if answer == 1 {
            didClickResponseBtn(btn: answer2Btn)
        }
        
        layoutMyUI()
    }
    
    private func layoutMyUI() {
        bottomLine.snp.removeConstraints()
        if needCheckFlag == true {
            if answer1Btn.isSelected == false && answer2Btn.isSelected == false {
                
                noTextTipsLable.isHidden = false
                noTextTipsLable.snp.removeConstraints()
                noTextTipsLable.snp.remakeConstraints { make in
                    make.top.equalTo(answer1Btn.snp.bottom).offset(6)
                    make.left.right.equalToSuperview()
                    make.height.equalTo(20)
                }
                
                bottomLine.snp.makeConstraints { make in
                    make.top.equalTo(noTextTipsLable.snp.bottom).offset(6)
                    make.left.right.equalToSuperview()
                    make.height.equalTo(0.5)
                    make.bottom.equalToSuperview()
                }
                return
            }
        }
        noTextTipsLable.isHidden = true
        bottomLine.snp.makeConstraints { make in
            make.top.equalTo(answer1Btn.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
            make.bottom.equalToSuperview()
        }
    }
}
