//
//  YHWorkExampleViewController.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHWorkExampleType: Int {
    case wduty = 0
    case highlight = 1
    case introduction = 2
}

class YHWorkExampleViewController: YHBaseViewController {
    typealias ExampleBlock = (_ message: String) -> Void
    var exampleBlock: ExampleBlock?
    var closeButton: UIButton!
    var titleLabel: UILabel!
    var lineView: UIView!
    var typeView: YHWorkExampleTypeView!
    var messageView: YHWorkExampleMessageView!
    var dataSource: [YHWorkExampleModel]?
    var type: YHWorkExampleType = .wduty
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setView()
        
        gk_navBackgroundColor = .clear
        gk_navShadowColor = .clear
        gk_navigationBar.isHidden = true
        getData()
    }
    
    func setView() {
        view.backgroundColor = .white
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setImage(UIImage(named: "work_example_close"), for: .normal)
            button.addTarget(self, action: #selector(close), for: .touchUpInside)
            return button
        }()
        view.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.top.equalTo(16)
            make.width.height.equalTo(24)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "参考示例"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            return label
        }()
        view.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        lineView = {
            let line = UIView()
            line.backgroundColor = UIColor.separatorColor
            return line
        }()
        view.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(52)
            make.height.equalTo(1)
        }
        
        typeView = {
            let view = YHWorkExampleTypeView()
            view.dataSource = self.getData()
            view.isHidden = false
            view.exampleBlock = {[weak self] index in
                guard let self = self else { return }
                view.isHidden = true
                self.messageView.isHidden = false
                self.messageView.titleLabel.text = self.getExampleTitle(index: index)
                self.messageView.dataSource = self.getExampleArray(index: index)
            }
            return view
        }()
        view.addSubview(typeView)
        typeView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(53)
            make.height.equalTo(KScreenHeight - 150)
        }
        
        messageView = {
            let view = YHWorkExampleMessageView()
            view.backBlock = {[weak self] in
                guard let self = self else { return }
                view.isHidden = true
                self.typeView.isHidden = false
            }
            view.exampleBlock = { [weak self] message in
                if let block = self?.exampleBlock {
                    block(message)
                }
                self?.close()
            }
            view.isHidden = true
            return view
        }()
        view.addSubview(messageView)
        messageView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(53)
            make.height.equalTo(KScreenHeight - 150)
        }
    }
    
    func getData() -> [String] {
        var array: [String] = []
        guard let dataSource = dataSource else { return []}
        for item in dataSource {
            array.append(item.industry ?? "")
        }
        return array
    }
    
    func getExampleArray(index: Int) -> [String] {
        if type == .wduty {
            return dataSource?[index].wduty_list ?? []
        } else if type == .highlight {
            return dataSource?[index].highlights_list ?? []
        }
        return dataSource?[index].template ?? []
    }
    
    func getExampleTitle(index: Int) -> String {
        return dataSource?[index].industry ?? ""
    }
    
    @objc func close() {
        self.dismiss(animated: true)
    }
}
